<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 25/08/2020
 * Time: 03:24 PM
 */

namespace App\Models\Tenant\Company\Employee;

use App\Helper\HelperChecker;
use App\Helper\StorageHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;
use function PHPSTORM_META\type;

class EmployeeRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;
    protected $storageHelper;

    public function __construct()
    {
        $this->obj = new Employee();
        $this->helperChecker = new HelperChecker();
        $this->storageHelper = new StorageHelper();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $type_dni = config('app.typedocument_dni');
        $this->helperChecker->checkEmployeeDocument($attributes['document']);
        $this->helperChecker->checkDocumentLengthByTypeDocument($attributes['document'], $type_dni);

        $item = new Employee();
        $item->companyjob_id = $attributes['companyjob_id'];
        $item->typedocument_id = $attributes['type_document'];
        $item->fullname = $attributes['fullname'];
        $item->document = $attributes['document'];
        $item->telephone = $attributes['telephone'];
        $item->cellphone = $attributes['cellphone'];
        $item->email = $attributes['email'];
        $item->address = $attributes['address'];
        $item->sex = $attributes['sex'];
        $item->status = $attributes['status'];
        $item->date_birthday = $attributes['date_birthday'];
        $item->url_image = null;
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;

    }

    public function updated($id, array $attributes)
    {
        $this->helperChecker->checkEmployeeDocumentUpdate($attributes['document'], $id);
        $this->helperChecker->checkDocumentLengthByTypeDocument($attributes['document'], $attributes['type_document']);

        $item = $this->obj->find($id);
        $item->companyjob_id = $attributes['companyjob_id'];
        $item->typedocument_id = $attributes['type_document'];
        $item->fullname = $attributes['fullname'];
        $item->document = $attributes['document'];
        $item->telephone = $attributes['telephone'];
        $item->cellphone = $attributes['cellphone'];
        $item->email = $attributes['email'];
        $item->address = $attributes['address'];
        $item->sex = $attributes['sex'];
        $item->status = $attributes['status'];
        $item->date_birthday = $attributes['date_birthday'];
        $item->url_image = null;
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;

    }

    public function saveUrlImage($item, $attributes)
    {
        $image = $attributes['url_image'];
        if ($image != null) {
            $file_url = $this->storageHelper->saveUrlImgEmployee($attributes);
            $item->url_image = $file_url;
            $item->save();
        }
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);

        return $this->obj
            ->select('company_employees.id as id', 'fullname', 'document', 'address', 'email', 'config_typedocument.id as typedocument_id','companyjob_id',
                DB::raw("concat(config_typedocument.description, ' : ' , company_employees.document) AS str_document"))
            ->join('config_typedocument', 'company_employees.typedocument_id', '=', 'config_typedocument.id')
            ->where('company_employees.deleted_at', null)
            ->where('fullname', 'LIKE', '%' . $text_search . '%')
            ->orwhere('document', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}