<?php


namespace App\Models\Tenant\Config\BillingCode;


use App\Models\Contract\BaseRepositoryInterface;

class BillingCodeRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new BillingCode();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        $query = $this->obj;



        return $this->obj->orderBy('id', 'ASC')->get();
    }

    public function allByVoucher($voucher_id)
    {
        $query = $this->obj;

        if($voucher_id == config('app.voucher_creditnote_id')){
            $query = $query->where('is_creditnote', true);
        }
        else{
            $query = $query->where('is_debitnote', true);
        }

        $query = $query->orderBy('id', 'ASC')->get();

        return $query;
    }


    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
