<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 27/05/2020
 * Time: 03:30 PM
 */

namespace App\Models\Tenant\Config\SerieVoucher;

use App\Models\Contract\BaseRepositoryInterface;

class SerieVoucherRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new SerieVoucher();
    }

    public function model()
    {
        // TODO: Implement model() method.
    }

    public function allSerieByVoucher($voucher_id, $branchoofice_id)
    {
        $query = $this->obj
            ->where('branchoffice_id', $branchoofice_id)
            ->where('voucher_id', $voucher_id)
            ->orderBy('id', 'ASC')
            ->get();
        return $query;
    }

    public function all()
    {

    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj
            ->where('id', $id)
            ->first();
    }

    public function findByVoucher($id)
    {
        return $this->obj
            ->where('deleted_at', null)
            ->where('voucher_id', $id)
            ->first();
    }

    public function findByVoucherAndBranchOffice($id, $serie = null, $branchoffice_id)
    {
        $query = $this->obj
            ->where('deleted_at', null)
            ->where('voucher_id', $id)
            ->where('branchoffice_id', $branchoffice_id);

        if ($serie != null) {
            $query = $query->where('series', $serie);
        }
        return $query->first();
    }

    public function updatedCorrelative($id, $correlativo)
    {
        $item = $this->find($id);
        $item->correlative = $correlativo;
        $item->save();
        return $item;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}