<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 15/07/2020
 * Time: 02:59 PM
 */

namespace App\Models\Tenant\Config\TypeVoucher;


use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class TypeVoucherRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new TypeVoucher();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allTypePurchase()
    {
        return $this->obj->where('is_module_purchase', true)->get();
    }

    public function allTypeSale()
    {
        return $this->obj->where('is_module_pay', true)->get();
    }

    public function allTypeBilling()
    {
        return $this->obj
            ->whereBetween('id', [config('app.voucher_boleta_id'), config('app.voucher_factura_id')])
            ->get();
    }

    public function allTypeNotes()
    {
        return $this->obj
            ->where('is_module_pay', true)
            ->whereBetween('id', [config('app.voucher_creditnote_id'), config('app.voucher_debitnote_id')])
            ->get();
    }

    public function saleByVoucher($parameters = null){
        $query = array();

        if($parameters != null){
            $branchoffice = "";
            $range_date = "";
            if (isset($parameters['branchoffice'])) {
                if($parameters['branchoffice'] != 'null')
                    $branchoffice = " AND money_movements.branchoffice_id = ".$parameters['branchoffice'];
            }

            if (isset($parameters['start_range'])) {
                if($parameters['start_range'] != 'null')
                    $range_date = " AND DATE(money_movements.date_movement) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."'";
            }

            $query = DB::connection('tenant')
                ->select("SELECT
                        config_typevoucher.description,
                        (
                        SELECT count(*) FROM money_movements
                        WHERE money_movements.voucher_id = config_typevoucher.id
                        ".$branchoffice.$range_date."
                        ) AS quantity_sale,
                    (
                        SELECT
                            CASE
                                WHEN SUM(money_movements.amount) ISNULL THEN 0
                                ELSE SUM(money_movements.amount)
                            END AS total
                        FROM money_movements
                        WHERE money_movements.voucher_id = config_typevoucher.id
                        ".$branchoffice.$range_date."
                        ) AS total_sale
                    FROM
                        config_typevoucher
                    WHERE
                        config_typevoucher.is_module_pay = TRUE
                    ORDER BY total_sale DESC");
        }

        return $query;
    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
