<?php

namespace App\Models\Tenant\Config\UnitMeasure;

use App\Models\Contract\BaseRepositoryInterface;

class UnitMeasureRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new UnitMeasure();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function unitParents()
    {
        return $this->obj->where('parent_unit_id',null)->get();
    }

    public function unitChilds($parent_id)
    {
        return $this->obj->where('parent_unit_id',$parent_id)->get();
    }

    public function unitAllChilds()
    {
        return $this->obj->where('is_principal', false)->get();
    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}