<?php

namespace App\Models\Tenant\Finance\AccountBank;

use App\Core\ModelsCore;
use App\Models\Tenant\Finance\Bank\BankRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class AccountBank extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'finance_accountbanks';

    protected $appends = ["concat_description", "bank"];

    protected $rBank;

    public function __construct()
    {
        $this->rBank = new BankRepository();
    }

    public function getConcatDescriptionAttribute()
    {
        if (isset($this->attributes['name'])) {
            $description_bank = $this->rBank->find($this->attributes['bank_id']);
            $concat_description = $description_bank['description']." - ".$this->attributes['name'];
            return $concat_description;
        }
    }

    public function getbankAttribute()
    {
        if (isset($this->attributes['bank_id'])) {
            $description_bank = $this->rBank->find($this->attributes['bank_id']);
            return $description_bank['description'];
        }
    }
}
