<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 07/09/2020
 * Time: 05:41 PM
 */

namespace App\Models\Tenant\Finance\AccountBank;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class AccountBankRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;


    public function __construct()
    {
        $this->obj = new AccountBank();
        $this->utilHelper = new UtilHelper();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allByBranchoffice()
    {
        $query = $this->obj
            ->where("branchoffice_id", $this->utilHelper->getBranchOffice())
            ->where("deleted_at", null)
            ->get();
        return $query;
    }

    public function listAccountBank($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $data = $model
            ->join('finance_typeaccount', 'finance_accountbanks.typeaccount_id', '=', 'finance_typeaccount.id')
            ->join('finance_banks', 'finance_accountbanks.bank_id', '=', 'finance_banks.id')
            ->join('branch_offices', 'finance_accountbanks.branchoffice_id', '=', 'branch_offices.id')
            ->join('config_currency', 'finance_accountbanks.currency_id', '=', 'config_currency.id')
            ->select('finance_accountbanks.*',
                'finance_typeaccount.description as typeaccount',
                'finance_banks.description as bank',
                'config_currency.description as currency',
                'branch_offices.description as branchoffice')
            ->where('finance_accountbanks.deleted_at', null);


        $all_data = $model->all();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('finance_accountbanks.name', 'LIKE', '%'. $text_search.'%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('finance_accountbanks.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $item = new AccountBank();
        $item->branchoffice_id = $attributes['branchoffice_id'];
        $item->typeaccount_id = $attributes['typeaccount_id'];
        $item->bank_id = $attributes['bank_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->name = $attributes['name'];
        $item->number_account = $attributes['number_account'];
        $item->cci_account = $attributes['cci_account'];
        $item->headline = $attributes['headline'];
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);

        $item->branchoffice_id = $attributes['branchoffice_id'];
        $item->typeaccount_id = $attributes['typeaccount_id'];
        $item->bank_id = $attributes['bank_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->name = $attributes['name'];
        $item->number_account = $attributes['number_account'];
        $item->cci_account = $attributes['cci_account'];
        $item->headline = $attributes['headline'];
        $item->description = $attributes['description'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('name', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}