<?php


namespace App\Models\Tenant\Hotel\Bedroom;


use App\Core\ModelsCore;
use App\Models\Tenant\Hotel\Booking\BookingRepository;
use App\Models\Tenant\Hotel\RateBedroom\RateBedroomRepository;
use App\Models\Tenant\Hotel\RoomType\RoomtypeRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Bedroom extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'hotel_bedrooms';

    protected $appends = ["roomtype", "ratesbedrooms"];

    public function getroomtypeAttribute()
    {
        if (isset($this->attributes['roomtype_id'])) {
            $description = null;
            if($this->attributes['roomtype_id']){
                $type = new RoomtypeRepository();
                $data = $type->find($this->attributes['roomtype_id']);
                $description = $data;
//                $description = $data['description'];
            }
            return $description;
        }
    }

    public function getratesbedroomsAttribute()
    {
        $ratesbedrooms = [];
        $rRateBedroom = new RateBedroomRepository();
        $query = $rRateBedroom->model()
            ->selectRaw("*, hotel_bedroomrates.rate_id as id")
            ->where('hotel_bedroomrates.bedroom_id', $this->attributes['id'])
            ->where('hotel_bedroomrates.deleted_at', null)
            ->get();

        $ratesbedrooms = $query;

        return $ratesbedrooms;
    }



}
