<?php


namespace App\Models\Tenant\Hotel\Bedroom;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use App\Models\Tenant\Hotel\BedroomDetail\BedroomDetailRepository;
use Illuminate\Support\Facades\DB;

class BedroomRepository implements BaseRepositoryInterface
{
    protected $obj;
    protected $utilHelper;
    protected $rBedroomDetail;

    public function __construct()
    {
        $this->obj = new Bedroom();
        $this->utilHelper = new UtilHelper();
        $this->rBedroomDetail = new BedroomDetailRepository();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function resourcesPlanning()
    {
        $query = \DB::connection('tenant')->table('hotel_bedrooms')
            ->selectRaw("id, CONCAT('HAB: ',code_number) as title")
            ->get();
        return $query;
    }

    public function availableBedroom($parameters)
    {
        $query = $this->structureList();
//        $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '12:00:00'));
//        $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '13:00:00'));

        $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '12:59:59'));
        $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '11:59:59'));

        $query = $query
            ->join('hotel_detailguests', 'hotel_bookings.id', '=', 'hotel_detailguests.booking_id')
            ->leftjoin('sale_clients', 'hotel_detailguests.client_id', '=', 'sale_clients.id')
            ->selectRaw("
                sale_clients.fullname as responsible,
                sale_clients.document as responsible_document
                ")
            ->where("hotel_detailbedrooms.bedroom_id", $parameters['bedroom_id'])
            ->where("hotel_detailguests.is_responsible", true)
            ->where("hotel_bookings.deleted_at", null)
            ->where("hotel_detailbedrooms.deleted_at", null);

            if($this->utilHelper->strToBooleanValue($parameters['is_edit'])){
                $query = $query->where("hotel_detailbedrooms.booking_id","<>", $parameters['booking_id']);
            }

            $query = $query->whereIn('hotel_bedrooms.id', function($sql) use ($star_range, $end_range)
            {
                $sql->select(\DB::raw("hotel_detailbedrooms.bedroom_id"))
                    ->from('hotel_detailbedrooms');

                $sql = $sql->where(function ($newsql) use ($star_range, $end_range) {
                    $newsql->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range]);
                    $newsql->orWhereBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range]);
                    return $newsql;
                });

                return $sql;
            })->get();

        return $query;
    }

    public function availableBedroomsToday($parameters)
    {

        $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '12:59:59'));
        $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '11:59:59'));

        $model = $this->model();
        $query = $model->select("*");
        $model_bedroom_detail = $this->rBedroomDetail->model();
        // $sub_query = $model_bedroom_detail->select("hotel_detailbedrooms.bedroom_id")

        //     ->where(function ($sql) use ($star_range, $end_range) {
        //     $sql->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range]);
        //     $sql->orWhereBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range]);
        //     return $sql;

        // })->get();

        $sub_query = $model_bedroom_detail
            ->join('hotel_bookings', 'hotel_detailbedrooms.booking_id', '=', 'hotel_bookings.id')
            ->select("hotel_detailbedrooms.bedroom_id")
            ->whereRaw("
                (
                    ('" . $star_range . "' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout )
                    OR ('" . $end_range . "' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout)
                )
            ")->whereRaw("hotel_bookings.is_checkout IS FALSE")->get();

        $temp_arr = array();
        foreach($sub_query as $i){
            array_push($temp_arr, $i->bedroom_id);
        }
        $query = $query
//            ->where("is_dirty",false)
            ->whereNotIn('id', $temp_arr);

        $all_data = $query->get();
        $query = $query->orderBy('hotel_bedrooms.id', 'ASC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function structureList()
    {
        $model = $this->model();
        $query = $model
            ->leftjoin('hotel_detailbedrooms', 'hotel_bedrooms.id', '=', 'hotel_detailbedrooms.bedroom_id')
            ->leftjoin('hotel_roomtypes', 'hotel_bedrooms.roomtype_id', '=', 'hotel_roomtypes.id')
            ->join('hotel_bookings', 'hotel_detailbedrooms.booking_id', '=', 'hotel_bookings.id')
            ->selectRaw("
                hotel_bedrooms.*,
                hotel_bedrooms.id as bedroom_id,
                hotel_roomtypes.id as roomtype_id,
                hotel_roomtypes.description as roomtype_description,
                hotel_roomtypes.abbreviation as roomtype_abbreviation,
                hotel_detailbedrooms.date_checkin,
	            hotel_detailbedrooms.date_checkout,
	             hotel_bookings.code as code_booking
                ");
        return $query;
    }

    public function list($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();


        $query = $this->structureList();

//            ->where('booking_bookings.type_booking', config('app.type_booking_direct'))
//            ->where('hotel_bedrooms.deleted_at', null)
        ;

        if ($parameters != null) {

//            if (isset($parameters['checkin'])) {
//                $query = $query->where('booking_bookings.is_checkin', true);
//            }

            if (isset($parameters['search'])) {
                if ($parameters['search'] != 'null') {
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use ($text_search) {
                            $sql->where('hotel_bedrooms.code_number', 'like', '%' . $text_search . '%')
//                                ->orWhere('booking_bookings.reference_voucher', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.fullname', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.document', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.cellphone', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.telephone', 'like', '%' . $text_search . '%')
                            ;
                        });
                    }
                } else {
                    if (isset($parameters['start_range'])) {
                        $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '12:59:59'));
                        $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '11:59:59'));

                        $query = $query->where(function ($sql) use ($star_range, $end_range) {
                            $sql->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range]);
                            $sql->orWhereBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range]);
                            return $sql;
                        });

//                        $query = $query->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range])
//                            ->orWhereBetween(DB::raw('hotel_detailbedrooms.date_checkout'), [$star_range, $end_range]);
//
//
//                        $first_part = $query;
//                        $second_part = $this->structureList()
//                            ->whereNotBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range])
//                            ->whereNotBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range])
//                            ->union($first_part)
//                            ->get();
//
//                        dd($second_part);
                    }
                }
            }
        }


        $all_data = $query->get();

//        if ($export) {
//            $query = $query->orderBy('booking_bookings.id', 'DESC')->get();
//        }
//        elseif (isset($parameters['checkin'])){
//            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('booking_bookings.date_arrival', 'DESC')->get()->toArray();
//        }
//        else {
//            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('hotel_bedrooms.id', 'DESC')->get()->toArray();
//        }

//        $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('hotel_bedrooms.id', 'ASC')->get()->toArray();
        $query = $query->orderBy('hotel_bedrooms.id', 'ASC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $item = new Bedroom();
        $item->roomtype_id = $attributes['roomtype_id'];
        $item->code_number = $attributes['code_number'];
        $item->description = $attributes['description'];
        $item->floor = $attributes['floor'];
        $item->observations = $attributes['observations'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->roomtype_id = $attributes['roomtype_id'];
        $item->code_number = $attributes['code_number'];
        $item->description = $attributes['description'];
        $item->floor = $attributes['floor'];
        $item->observations = $attributes['observations'];
        $item->save();
        return $item;
    }

    public function enableBedroom($id)
    {
        $item = $this->obj->find($id);
        $item->is_dirty = false;
        $item->save();
        return $item;
    }

    public function maintenanceBedroom($id)
    {
        $item = $this->obj->find($id);
        $item->is_dirty = true;
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function passToDirty($id)
    {
        $item = $this->obj->find($id);
        $item->is_dirty = true;
        $item->save();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('code_number', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}
