<?php

namespace App\Models\Tenant\Hotel\BedroomDetail;

use App\Core\ModelsCore;
use App\Models\Tenant\Hotel\Bedroom\BedroomRepository;
use App\Models\Tenant\Hotel\Booking\BookingRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class BedroomDetail extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'hotel_detailbedrooms';


    protected $appends = ["booking", "bedroom_data"];

    public function getbookingAttribute()
    {
        if (isset($this->attributes['booking_id'])) {
            $response = null;
            if ($this->attributes['booking_id']) {
                $type = new BookingRepository();
                $data = $type->find($this->attributes['booking_id']);
                $response = $data;
            }
            return $response;
        }
    }

    public function getbedroomDataAttribute()
    {
        if (isset($this->attributes['bedroom_id'])) {
            $response = null;
            if ($this->attributes['bedroom_id']) {
                $type = new BedroomRepository();
                $data = $type->find($this->attributes['bedroom_id']);
                $response = $data;
            }
            return $response;
        }
    }
}
