<?php


namespace App\Models\Tenant\Hotel\BedroomDetail;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class BedroomDetailRepository implements BaseRepositoryInterface
{
    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new BedroomDetail();

        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function eventsPlanning($parameters)
    {
        $model = $this->model();
        $query = $model
            ->join('hotel_bookings', 'hotel_detailbedrooms.booking_id', '=', 'hotel_bookings.id')
            ->join('hotel_detailguests', 'hotel_bookings.id', '=', 'hotel_detailguests.booking_id')
            ->join('sale_clients', 'hotel_detailguests.client_id', '=', 'sale_clients.id')
            ->selectRaw("
                hotel_detailbedrooms.bedroom_id as resourceId,
                sale_clients.fullname as title,
                DATE(hotel_detailbedrooms.date_checkin) as start,
                DATE(hotel_detailbedrooms.date_checkout) as end,
                hotel_bookings.is_checkout      
                ")
                ->where("hotel_detailguests.is_responsible", TRUE);
        if ($parameters != null) {
            if (isset($parameters['start_range'])) {
                $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '12:00:00'));
                $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '13:00:00'));

                $query = $query->where(function ($sql) use ($star_range, $end_range) {
                    $sql->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range]);
                    $sql->orWhereBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range]);
                    return $sql;
                });
            }
        }

        $response = $query->get();

        return $response;
    }

    public function availableBedroom($parameters)
    {

        $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '12:59:59'));
        $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '11:59:59'));

        $model = $this->model();
        $query = $model
            ->join('hotel_bookings', 'hotel_detailbedrooms.booking_id', '=', 'hotel_bookings.id')
            ->leftjoin('hotel_bedrooms', 'hotel_detailbedrooms.bedroom_id', '=', 'hotel_bedrooms.id')
            ->selectRaw("
                hotel_bedrooms.*,
                hotel_detailbedrooms.booking_id,
                hotel_bedrooms.id as bedroom_id,
                hotel_detailbedrooms.date_checkin,
	            hotel_detailbedrooms.date_checkout,
	            hotel_detailbedrooms.id as id
                ")
            ->where("hotel_detailbedrooms.bedroom_id", $parameters['bedroom_id'])
            ->where("hotel_bookings.deleted_at", null)
            ->where("hotel_detailbedrooms.deleted_at", null);

        if($this->utilHelper->strToBooleanValue($parameters['is_edit'])){
            $query = $query->where("hotel_detailbedrooms.booking_id","<>", $parameters['booking_id']);
        }

        // $query = $query->where(function ($sql) use ($star_range, $end_range) {
        //     // $sql->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range]);
        //     // $sql->orWhereBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range]);

        //     $sql->whereBetween($star_range, ['hotel_detailbedrooms.date_checkin', 'hotel_detailbedrooms.date_checkout']);
        //     $sql->orWhereBetween($end_range, ['hotel_detailbedrooms.date_checkin', 'hotel_detailbedrooms.date_checkout']);
        //     return $sql;
        // })->get();

        $query = $query->whereRaw("
        (
            ('". $star_range."' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout )
             OR ('".$end_range."' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout)
        )
        ");

        $query = $query->whereRaw("hotel_bookings.is_checkout IS FALSE");

        return $query->get();
    }

    public function structureList()
    {
        $model = $this->model();
        $query = $model
            ->leftjoin('hotel_bedrooms', 'hotel_detailbedrooms.bedroom_id', '=', 'hotel_bedrooms.id')
            ->leftjoin('hotel_roomtypes', 'hotel_bedrooms.roomtype_id', '=', 'hotel_roomtypes.id')
            ->join('hotel_bookings', 'hotel_detailbedrooms.booking_id', '=', 'hotel_bookings.id')
            ->selectRaw("
                hotel_bedrooms.*,
                hotel_detailbedrooms.booking_id,
                hotel_bedrooms.id as bedroom_id,
                hotel_roomtypes.id as roomtype_id,
                hotel_roomtypes.description as roomtype_description,
                hotel_roomtypes.abbreviation as roomtype_abbreviation,
                hotel_detailbedrooms.rate,
                hotel_detailbedrooms.number_nights,
                hotel_detailbedrooms.date_checkin,
	            hotel_detailbedrooms.date_checkout,
	            CASE
                    WHEN DATE('".date('Y-m-d')."') = DATE(hotel_detailbedrooms.date_checkin) THEN true
                    ELSE false
                 END AS alert_checkin,
                  CASE
                    WHEN DATE('".date('Y-m-d')."') = DATE(hotel_detailbedrooms.date_checkout) THEN true
                    ELSE false
                 END AS alert_checkout,
	            hotel_detailbedrooms.id as id
                ");
        return $query;
    }

    public function list($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $this->structureList();

        if(isset($parameters['is_extends'])){
             // todas las reservas realizadas pendientes de checkout    
             if (isset($parameters['is_checkin'])) {            
                if($this->utilHelper->strToBooleanValue($parameters['is_checkin'])){
                    $query = $query->whereRaw("hotel_bookings.is_checkin IS TRUE")
                    ->whereRaw("hotel_bookings.is_checkout IS FALSE");
                }
            }

            $all_data = $query->get();

            $query = $query->orderBy('hotel_detailbedrooms.date_checkin', 'ASC')->get()->toArray();

            $response = array(
                'results' => $query,
                'count' => count($query),
                'total' => count($all_data),
                'paginate_by' => config('app.paginate_by')
            );

            return $response;

        }
        else if(isset($parameters['is_all'])){
            // todas las reservas realizadas pendientes de checkout    
            if (isset($parameters['is_all'])) {            
               if($this->utilHelper->strToBooleanValue($parameters['is_all'])){
                   $query = $query->whereRaw("hotel_bookings.is_checkin IS FALSE");
               }
           }

           $all_data = $query->get();

           $query = $query->orderBy('hotel_detailbedrooms.date_checkin', 'ASC')->get()->toArray();

           $response = array(
               'results' => $query,
               'count' => count($query),
               'total' => count($all_data),
               'paginate_by' => config('app.paginate_by')
           );

           return $response;

       }
        else{
            
            if ($parameters != null) {    
                if (isset($parameters['is_checkout'])) { 
                        if ($this->utilHelper->strToBooleanValue($parameters['is_checkout'])) {
                            $query = $query->whereRaw("hotel_bookings.is_checkout IS TRUE");
                        } else {
                            $query = $query->whereRaw("hotel_bookings.is_checkout IS FALSE");
                        }
                }   

                if (isset($parameters['search'])) {
                    if ($parameters['search'] != 'null') {
                        $text_search = $parameters->get('search');
                        if ($text_search === 'null') {
                            $text_search = null;
                        }
                        if ($text_search !== null) {
                            $text_search = strtoupper($text_search);

                            $query = $query->where(function ($sql) use ($text_search) {
                                $sql->where('hotel_bedrooms.code_number', 'like', '%' . $text_search . '%');
                            });
                        }
                    } else {
                        if (isset($parameters['start_range'])) {

                            $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '00:00:00'));
                            $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '23:59:59'));
                            $query = $query->whereRaw("
                                (
                                    ( hotel_detailbedrooms.date_checkin BETWEEN  '" . $star_range . "' AND  '" . $end_range . "' )
                                   
                                    OR ( hotel_detailbedrooms.date_checkout BETWEEN '" . $star_range . "' AND '" . $end_range . "')
                                )
                            ")->orderBy('hotel_detailbedrooms.date_checkin', 'ASC');


                            // $query = $query->whereRaw("
                            // (
                            //     ('" . $star_range . "' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout )

                            //     OR ('" . $end_range . "' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout)
                            // )
                            // ");



                            //                        $query = $query->whereBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range])
                            //                            ->orWhereBetween(DB::raw('hotel_detailbedrooms.date_checkout'), [$star_range, $end_range]);
                            //
                            //
                            //                        $first_part = $query;
                            //                        $second_part = $this->structureList()
                            //                            ->whereNotBetween('hotel_detailbedrooms.date_checkin', [$star_range, $end_range])
                            //                            ->whereNotBetween('hotel_detailbedrooms.date_checkout', [$star_range, $end_range])
                            //                            ->union($first_part)
                            //                            ->get();
                            //
                            //                        dd($second_part);
                        }
                    }
                }
            }
    
            // second part query
            $second_part =  $this->structureList();
            if ($parameters != null) {
                if (isset($parameters['is_checkout'])) {
                    if ($this->utilHelper->strToBooleanValue($parameters['is_checkout'])) {
                        $second_part = $second_part->whereRaw("hotel_bookings.is_checkout IS TRUE");
                    } else {
                        $second_part = $second_part->whereRaw("hotel_bookings.is_checkout IS FALSE");
                    }
                }
    
                if (isset($parameters['search'])) {
                    if ($parameters['search'] != 'null') {
                        $text_search = $parameters->get('search');
                        if ($text_search === 'null') {
                            $text_search = null;
                        }
                        if ($text_search !== null) {
                            $text_search = strtoupper($text_search);
    
                            $second_part = $second_part->where(function ($sql) use ($text_search) {
                                $sql->where('hotel_bedrooms.code_number', 'like', '%' . $text_search . '%');
                            });
                        }
                    } else {
                        if (isset($parameters['start_range'])) {
    
                            $star_range = date('Y-m-d H:i:s', strtotime($parameters['start_range'] . ' ' . '00:00:00'));
                            $end_range = date('Y-m-d H:i:s', strtotime($parameters['end_range'] . ' ' . '23:59:59'));
                        
    
    
                                $second_part = $second_part->whereRaw("
                                (
                                    ('" . $star_range . "' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout )
                                   
                                    OR ('" . $end_range . "' BETWEEN hotel_detailbedrooms.date_checkin AND hotel_detailbedrooms.date_checkout)
                                )
                                ")->orderBy('hotel_detailbedrooms.date_checkin', 'ASC');
                        }
                    }
                }               
            }
    
            $second_part = $second_part->union($query);
            // ==================== end second part

            $all_data = $second_part->get();

            //        if ($export) {
            //            $query = $query->orderBy('booking_bookings.id', 'DESC')->get();
            //        }
            //        elseif (isset($parameters['checkin'])){
            //            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('booking_bookings.date_arrival', 'DESC')->get()->toArray();
            //        }
            //        else {
            //            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('hotel_bedrooms.id', 'DESC')->get()->toArray();
            //        }

            //        $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('hotel_bedrooms.id', 'ASC')->get()->toArray();

            $second_part = $second_part->get()->toArray();

            $response = array(
                'results' => $second_part,
                'count' => count($second_part),
                'total' => count($all_data),
                'paginate_by' => config('app.paginate_by')
            );

            return $response;

        }
        
    }


    public function create(array $attributes)
    {
        $item = new BedroomDetail();
        $item->booking_id = $attributes['booking_id'];
        $item->bedroom_id = $attributes['bedroom_id'];
        $item->roomtype_id = $attributes['roomtype_id'];
        $item->ratebedroom_id = $attributes['ratebedroom_id'];
        $item->rate = $attributes['rate'];
        $item->date_checkin = $this->utilHelper->concatDateAndTime($attributes['date_checkin'], $attributes['time_checkin']);
        $item->date_checkout = $this->utilHelper->concatDateAndTime($attributes['date_checkout'], $attributes['time_checkout']);
        $item->number_nights = $attributes['number_nights'];
        $item->number_kids = $attributes['number_kids'];
        $item->number_adults = $attributes['number_adults'];
        $item->number_towells = $attributes['number_towells'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->roomtype_id = $attributes['roomtype_id'];
        $item->ratebedroom_id = $attributes['ratebedroom_id'];
        $item->rate = $attributes['rate'];
        $item->date_checkin = $this->utilHelper->concatDateAndTime($attributes['date_checkin'], $attributes['time_checkin']);
        $item->date_checkout = $this->utilHelper->concatDateAndTime($attributes['date_checkout'], $attributes['time_checkout']);
        $item->number_nights = $attributes['number_nights'];
        $item->number_kids = $attributes['number_kids'];
        $item->number_adults = $attributes['number_adults'];
        $item->number_towells = $attributes['number_towells'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;

    }

    public function findByBooking($booking_id)
    {
        $item = $this->obj->where('booking_id', $booking_id)->where('deleted_at', null)->first();
        return $item;

    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
