<?php

namespace App\Models\Tenant\Hotel\Booking;

use App\Core\ModelsCore;
use App\Models\Tenant\Hotel\GuestDetail\GuestDetailRepository;
use App\Models\Tenant\Sale\Client\ClientRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Booking extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'hotel_bookings';


    protected $appends = ["guests", "status_booking"];


    public function getguestsAttribute()
    {
        $guests = [];
        $rGuest = new GuestDetailRepository();
        $query = $rGuest->model()
            ->join('sale_clients', 'sale_clients.id', '=', 'hotel_detailguests.client_id')
            ->selectRaw("*, sale_clients.*, hotel_detailguests.client_id as id")
            ->where('hotel_detailguests.booking_id', $this->attributes['id'])
            ->where('hotel_detailguests.deleted_at', null)
//            ->orderBy('hotel_detailguets.is_responsible', 'ASC')
            ->get();

        $guests = $query;

        return $guests;
    }

    public function getstatusBookingAttribute()
    {
        $response = array(
            'class' => 'warning',
            'message' => 'Reservado',
        );

        if (isset($this->attributes['is_checkin'])) {
            if ($this->attributes['is_checkin'] == true) {
                $response = array(
                    'class' => 'checkin',
                    'message' => 'Confirmado',
                );
            }
        }

        if (isset($this->attributes['is_checkout'])) {
            if ($this->attributes['is_checkout'] == true) {
                $response = array(
                    'class' => 'dark',
                    'message' => 'Checkout',
                );
            }
        }

        if (isset($this->attributes['is_postponed'])) {
            if ($this->attributes['is_postponed'] == true) {
                $response = array(
                    'class' => 'purple',
                    'message' => 'Pospuesto',
                );
            }
        }

        return $response;
    }

}
