<?php


namespace App\Models\Tenant\Hotel\Booking;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class BookingRepository implements BaseRepositoryInterface
{
    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Booking();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function list($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $model
//            ->join('sale_clients', 'booking_bookings.client_id', '=', 'sale_clients.id')
            ->selectRaw("
                booking_bookings.*"
            )
//            ->where('booking_bookings.type_booking', config('app.type_booking_direct'))
            ->where('booking_bookings.deleted_at', null);

        if ($parameters != null) {

            if (isset($parameters['checkin'])) {
                $query = $query->where('booking_bookings.is_checkin', true);
            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('booking_bookings.code', 'like', '%' . $text_search . '%')
//                                ->orWhere('booking_bookings.reference_voucher', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.fullname', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.document', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.cellphone', 'like', '%' . $text_search . '%')
//                                ->orWhere('sale_clients.telephone', 'like', '%' . $text_search . '%')
                            ;
                        });
                    }
                }
                else{
                    if (isset($parameters['start_range'])) {
//                        $query = $query->whereBetween('booking_bookings.date_arrival', [$parameters['start_range'], $parameters['end_range']]);
                    }
                }
            }
        }

        $all_data = $query->get();

        if ($export) {
            $query = $query->orderBy('booking_bookings.id', 'DESC')->get();
        }
        elseif (isset($parameters['checkin'])){
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('booking_bookings.date_arrival', 'DESC')->get()->toArray();
        }
        else {
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('booking_bookings.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $get_correlative = $this->utilHelper->createBookingDirectCorrelative();

        $item = new Booking();
        $item->user_id = auth()->user()->id;
//        $item->client_id = $attributes['client_id'];
//        $item->agency_id = config('app.agency_principal');
        $item->code = $get_correlative['code'];
        $item->correlative = $get_correlative['correlative'];

//        $item->date_arrival = $this->utilHelper->concatDatetime($attributes['date_arrival'], $attributes['time_arrival']);
        $item->bookingorigin_id = $attributes['bookingorigin_id'];
        $item->arrivalplace_id = $attributes['arrivalplace_id'];
//        $item->nro_pax = $attributes['nro_pax'];
//        $item->date_arrival = $attributes['date_arrival'];
//        $item->time_arrival = $attributes['time_arrival'];
//        $item->reference_voucher = $attributes['reference_voucher'];
//        $item->observations = $attributes['observations'];
        $item->arrival_place = $attributes['arrival_place'];
//        $item->reference_location = $attributes['reference_location'];
//        $item->contact_emergency = $attributes['contact_emergency'];
//        $item->telephone_emergency = $attributes['telephone_emergency'];
//        $item->is_detail_subtotaltour = $attributes['is_detail_subtotaltour'];
//        $item->register_flight = $attributes['register_flight'];

//        $item->subtotal_tour = $attributes['subtotal_tour'];
//        $item->subtotal_hotel = $attributes['subtotal_hotel'];
//        $item->subtotal_flight = $attributes['subtotal_flight'];
        $item->text_amount = $attributes['text_amount'];
        $item->total = $attributes['total'];
        $item->save();
        return $item;


    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->user_id = auth()->user()->id;
        $item->bookingorigin_id = $attributes['bookingorigin_id'];
        $item->arrivalplace_id = $attributes['arrivalplace_id'];
        $item->arrival_place = $attributes['arrival_place'];
        $item->text_amount = $attributes['text_amount'];
        $item->total = $attributes['total'];
        $item->save();
        return $item;
    }

    public function checkin($id)
    {
        $item = $this->obj->find($id);
        $item->is_checkin = true;
        $item->save();
        return $item;
    }
    public function checkout($id)
    {
        $item = $this->obj->find($id);
        $item->is_checkout = true;
        $item->save();
        return $item;
    }

    public function getBookingLastCheckCorrelative()
    {
        $item = $this->obj
//            ->where('type_booking', config('app.type_booking_direct'))
            ->orderBy('id', 'desc')
            ->first();

        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
