<?php

namespace App\Models\Tenant\Hotel\GuestDetail;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class GuestDetail extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'hotel_detailguests';

    protected $appends = ["age_group_description"];


    public function getageGroupDescriptionAttribute()
    {
        $response = "Adulto";

        if ($this->attributes['age_group'] === "N") {
            $response = "Niño";
        }

        if ($this->attributes['age_group'] === "I") {
            $response = "Infante";
        }

        return $response;
    }


}
