<?php


namespace App\Models\Tenant\Hotel\GuestDetail;

use App\Models\Contract\BaseRepositoryInterface;

class GuestDetailRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new GuestDetail();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new GuestDetail();
        $item->client_id = $attributes['client_id'];
        $item->booking_id = $attributes['booking_id'];
        $item->age_group = $attributes['age_group'];
        $item->is_responsible = $attributes['is_responsible'];
        $item->nationality = null;
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->client_id = $attributes['client_id'];
        $item->booking_id = $attributes['booking_id'];
        $item->age_group = $attributes['age_group'];
        $item->is_responsible = $attributes['is_responsible'];
        $item->nationality = null;
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findBybooking($booking_id)
    {
       $query = $this->obj
           ->join('sale_clients','sale_clients.id', '=', 'hotel_detailguests.client_id')
           ->selectRaw("
                sale_clients.*,
                hotel_detailguests.*,
                hotel_detailguests.id as id
                ")
           ->where("hotel_detailguests.booking_id", $booking_id)
           ->where("hotel_detailguests.deleted_at", null)
           ->get();

       return $query;
    }

    public function findByBookingAndClient($booking_id, $client_id)
    {
        $query = $this->obj
            ->where("hotel_detailguests.booking_id", $booking_id)
            ->where("hotel_detailguests.client_id", $client_id)
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
