<?php

namespace App\Models\Tenant\Hotel\RateBedroom;

use App\Core\ModelsCore;
use App\Models\Tenant\Hotel\Rate\RateRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class RateBedroom extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'hotel_bedroomrates';

    protected $appends = ["rate"];

    public function getrateAttribute()
    {
        if (isset($this->attributes['rate_id'])) {
            $description = null;
            if($this->attributes['rate_id']){
                $type = new RateRepository();
                $data = $type->find($this->attributes['rate_id']);
                $description = $data['description'];
            }
            return $description;
        }
    }
}
