<?php


namespace App\Models\Tenant\Hotel\RateBedroom;

use App\Models\Contract\BaseRepositoryInterface;

class RateBedroomRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new RateBedroom();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new RateBedroom();
        $item->bedroom_id = $attributes['bedroom_id'];
        $item->rate_id = $attributes['rate_id'];
        $item->price = $attributes['price'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->bedroom_id = $attributes['bedroom_id'];
        $item->rate_id = $attributes['rate_id'];
        $item->price = $attributes['price'];
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findByBedroom($bedroom_id)
    {
        return $this->obj
            ->where('bedroom_id',$bedroom_id)
            ->where('deleted_at', null)
            ->get();
    }

    public function findByBedroomAndRate($bedroom_id, $rate_id)
    {
        return $this->obj
            ->where('bedroom_id',$bedroom_id)
            ->where('rate_id', $rate_id)
//            ->where('deleted_at', null)
            ->first();
    }

    public function deletedByBedroomAndRate($bedroom_id, $rate_id)
    {
        $item = $this->obj
            ->where('bedroom_id',$bedroom_id)
            ->where('rate_id', $rate_id)
            ->where('hotel_bedroomrates.deleted_at', null)
            ->first();

        $item->delete();
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
