<?php


namespace App\Models\Tenant\Hotel\RoomType;


use App\Helper\HelperChecker;
use App\Models\Contract\BaseRepositoryInterface;

class RoomtypeRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new RoomType();
        $this->helperChecker = new HelperChecker();
    }


    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $this->helperChecker->checkSeemDescriptionModel($this->model(), 'description', $attributes['description'], 'Tipo Habitación');

        $item = new RoomType();
        $item->description = $attributes['description'];
        $item->abbreviation = $attributes['abbreviation'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->abbreviation = $attributes['abbreviation'];
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}
