<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 22/06/2020
 * Time: 04:11 PM
 */

namespace App\Models\Tenant\Inquiry\Response;


use App\Helper\HelperChecker;
use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class ResponseRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;
    protected $utilHelper;


    public function __construct()
    {
        $this->obj = new Response();
        $this->helperChecker = new HelperChecker();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
//        if($this->helperChecker->checkClientInSurveyResponse($attributes)) {
            $item = new Response();
            $item->client_id = $attributes['client_id'];
            $item->survey_id = $attributes['survey_id'];
            $item->employed_id = $attributes['employed_id'];
            $item->date_response = $this->utilHelper->transformDatetime($attributes['date_response']);
            $item->save();
            return $item;
//        }
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findBySurveyIdJoined($survey_id)
    {
        return $this->obj
            ->join('inquiry_surveys', 'inquiry_responses.survey_id', '=', 'inquiry_surveys.id')
            ->join('sale_clients', 'inquiry_responses.client_id', '=', 'sale_clients.id')
            ->join('users', 'inquiry_responses.employed_id', '=', 'users.id')
            ->select('inquiry_surveys.*', 'sale_clients.fullname as client_fullname', 'users.name as employed_fullname', 'inquiry_responses.date_response')
            ->where('inquiry_surveys.deleted_at', null)
            ->where('inquiry_responses.survey_id', $survey_id)
            ->get();
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}