<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 27/05/2020
 * Time: 06:21 PM
 */

namespace App\Models\Tenant\Management\User;

use App\Helper\HelperChecker;
use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;
    protected $helperChecker;

    public function __construct()
    {
        $this->obj = new UserTenant();
        $this->utilHelper = new UtilHelper();
        $this->helperChecker = new HelperChecker();
    }


    public function model()
    {
        return $this->obj;

    }

    public function all()
    {
        $items = $this->obj->where('is_superadmin', false)->get();
        return $items;
    }


    public function allSeller()
    {
        $items = $this->obj->where('profile_id', config('app.profile_seller'))->get();
        return $items;
    }


    public function listUser($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $status = $header->has('status') ? $header->get('status') : true;
        $profile = $header->has('profile') ? $header->get('profile') : null;

        $model = $this->model();

        $data = $model
            ->leftjoin('company_employees', 'users.employee_id', '=', 'company_employees.id')
            ->leftjoin('config_typedocument', 'company_employees.typedocument_id', '=', 'config_typedocument.id')
            ->join('user_profiles', 'users.profile_id', '=', 'user_profiles.id')
            ->select('users.*',
                'user_profiles.description as profile_description',
                'config_typedocument.description as typedocument',
                'company_employees.fullname as employee_fullname',
                'company_employees.document as employee_document')
            ->where('users.is_superadmin', false);

        // check status user
        if ($this->utilHelper->strToBooleanValue($status) == true) {
            $data = $data->where('users.deleted_at', null);

        } else if($this->utilHelper->strToBooleanValue($status) == false){
            $data = $data->where('users.deleted_at', '!=',null);
        }

        // check profile
        if($profile !== 'null'){
            $data = $data->where('profile_id', $profile);
        }

        $all_data = $data->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
//                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('users.username', 'LIKE', '%'. $text_search.'%')
                    ->orWhere('company_employees.fullname',  'LIKE', '%' . $text_search . '%')
                    ->orWhere('company_employees.document',  'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('users.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }


    public function create(array $attributes)
    {
        $this->helperChecker->checkUserTenantEmail($attributes['email']);

        $item = new UserTenant();
        $item->profile_id = $attributes['profile_id'];
        $item->employee_id = $attributes['employee_id'];
        $item->username = $attributes['username'];
//        $item->name = $attributes['name'];
//        $item->surname = $attributes['surname'];
//        $item->document = $attributes['document'];
//        $item->telephone = $attributes['telephone'];
//        $item->address = $attributes['address'];
        $item->email = $attributes['email'];
        $item->password = Hash::make($attributes['password']);
        $item->save();
        return $item;

    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->profile_id = $attributes['profile_id'];
        $item->employee_id = $attributes['employee_id'];
        $item->username = $attributes['username'];
//        $item->name = $attributes['name'];
//        $item->surname = $attributes['surname'];
//        $item->document = $attributes['document'];
//        $item->telephone = $attributes['telephone'];
//        $item->address = $attributes['address'];
        $item->email = $attributes['email'];

        if($this->utilHelper->strToBooleanValue($attributes['change_password']) == true){
            $item->password = Hash::make($attributes['password']);
        }

        $item->save();
        return $item;
    }

    public function updatePassword($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->password = Hash::make($attributes['password']);
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function findJoined($id)
    {
        $item = $this->obj
            ->leftjoin('company_employees', 'users.employee_id', '=', 'company_employees.id')
            ->select('users.*','company_employees.fullname as employee_fullname')
            ->where('users.deleted_at', null)
            ->where('users.id', $id)
            ->first();

        return $item;
    }

    public function getUserById($id)
    {
        $item = $this->obj->where('id',$id)->get();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function activated($id)
    {
        $item = $this->obj->find($id);
        $item->deleted_at = null;
        $item->save();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->select('id',
                DB::raw("CONCAT(name, ' ', surname) AS fullname"),
                DB::raw("CONCAT('N° Doc : ', document) AS document"))
            ->where('deleted_at', null)
            ->where('is_superadmin', false)
            ->where('name', 'LIKE', '%' .$text_search. '%')
            ->orwhere('surname', 'LIKE', '%' .$text_search. '%')
            ->orwhere('document', 'LIKE', '%' .$text_search. '%')
            ->get();

    }
}