<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 23/07/2020
 * Time: 12:12 AM
 */

namespace App\Models\Tenant\Money\MoneyBox;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use App\Models\Tenant\Branch\BranchBoxes\BranchBoxesRepository;
use Illuminate\Support\Facades\DB;

class MoneyBoxRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;
    protected $rBranchBox;

    public function __construct()
    {
        $this->obj = new MoneyBox();
        $this->utilHelper = new UtilHelper();
        $this->rBranchBox = new BranchBoxesRepository();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }


    public function listHistoryMoneyBox($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $data = $model
            ->join('branch_boxes', 'money_box.branchbox_id', '=', 'branch_boxes.id')
            ->join('users', 'money_box.user_id', '=', 'users.id')
            ->select('money_box.*',
                'branch_boxes.description as branchbox',
                'users.name as username')
            ->where('branch_boxes.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('money_box.date_closing','!=', null);

        $all_data = $model->all();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if ($text_search === 'null') {
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('money_box.amount_opening', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('money_box.date_closing', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }


    public function checkBox()
    {
//        $date_now = date('Y-m-d');
        $date_now = date('d M Y');
        $branchbox = $this->rBranchBox->getBranchBox();
        $arr_response = array(
            'code' => true
        );

        // VERIFIED IF NOT CLOSE THE LAST BOX
        $query = DB::connection('tenant')
            ->select('SELECT * FROM money_box
                            WHERE money_box.branchbox_id = ' . $branchbox . '
                            AND DATE(date_opening) <> \'' . $date_now . '\'
                            AND date_closing ISNULL');

        if (count($query) > 0) {
            $arr_response['code'] = false;
            $arr_response['message'] = 'La caja anterior aún continúa abierta. Debe cerrarla y abrir la caja actual para poder realizar movimientos de dinero.';
        } else {
            $query = DB::connection('tenant')
                ->select('SELECT * FROM money_box
                            WHERE money_box.branchbox_id = ' . $branchbox . '
                            AND DATE(date_opening) =  \'' . $date_now . '\'
                            AND money_box.date_closing ISNULL');

            if (count($query) == 0) {
                $arr_response['code'] = false;
                $arr_response['message'] = 'Aún no se ha aperturado la caja para la fecha de hoy '."\n " . $date_now;
            }
        }

        return $arr_response;
    }

    public function getBoxMoney()
    {
        $branchbox = $this->rBranchBox->getBranchBox();
        $date_now = date('Y-m-d');

        $query = DB::connection('tenant')
            ->select('SELECT money_box.*, users.name as username FROM money_box
                            INNER JOIN users ON money_box.user_id = users.id
                            WHERE money_box.branchbox_id = ' . $branchbox . '
                            AND DATE(date_opening) =  \'' . $date_now . '\'
                            AND money_box.date_closing ISNULL');

        if (count($query) == 0) {
            throw new \ErrorException('Debe aperturar la caja para poder realizar movimientos de dinero.');
        }

        return $query[0];
    }

    public function sumAmount($box, $amount)
    {
        $sum_amount = $box->balance + $amount;
        $item = $this->obj->find($box->id);
        $item->balance = $sum_amount;
        $item->save();
        return $item;
    }

    public function substractAmount($box, $amount)
    {
        if ($amount > $box->balance) {
            throw new \ErrorException('La caja no cuenta con el dinero suficiente para retirar el monto de S/. ' . $amount);
        } else {
            $substract_amount = $box->balance - $amount;
            $item = $this->obj->find($box->id);
            $item->balance = $substract_amount;
            $item->save();
            return $item;
        }
    }

    public function summaryPayMethod($box)
    {
        $date_now = date('Y-m-d');
        if ($box != false) {
            $box_id = $box->id;

            $date_now = date('Y-m-d', strtotime($box->date_opening));

            $query = DB::connection('tenant')
                ->select('SELECT
                    config_paymentmethod.description,
                (
                       SELECT
                            CASE
                            WHEN SUM(money_movements.amount) ISNULL THEN 0
                            ELSE SUM(money_movements.amount) 
                            END AS total
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id    
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = ' . $box_id . '
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS total,
                    (
                        SELECT
                            count(*)
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = ' . $box_id . '
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS transactions,
                    config_paymentmethod.bg_color,
                    config_paymentmethod.icon
                FROM
                    config_paymentmethod
                    WHERE config_paymentmethod.id <> ' . config('app.paymethod_quota') . '');
        } else {
            $query = DB::connection('tenant')
                ->select('SELECT
                    config_paymentmethod.description,
                (
                       SELECT
                            CASE
                            WHEN SUM(money_movements.amount) ISNULL THEN 0
                            ELSE SUM(money_movements.amount) 
                            END AS total
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = NULL
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS total,
                    (
                        SELECT
                            count(*)
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = NULL
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS transactions,
                    config_paymentmethod.bg_color,
                    config_paymentmethod.icon
                FROM
                    config_paymentmethod
                    WHERE config_paymentmethod.id <> ' . config('app.paymethod_quota') .'');
        }


        return $query;
    }

    public function summaryPayMethodArqueo($box)
    {
        $date_now = date('Y-m-d');
        if ($box != false) {
            $box_id = $box->id;

            $date_now = date('Y-m-d', strtotime($box->date_opening));

            $query = DB::connection('tenant')
                ->select('SELECT
                    config_paymentmethod.description,
                (
                       SELECT
                            CASE
                            WHEN SUM(money_movements.amount) ISNULL THEN 0
                            ELSE SUM(money_movements.amount) 
                            END AS total
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id    
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = ' . $box_id . '
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS total,
                    
                    (
                       SELECT
                            CASE
                            WHEN SUM(money_movements.amount) ISNULL THEN 0
                            ELSE SUM(money_movements.amount) 
                            END AS total
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id    
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = ' . $box_id . '
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_egreso') . '
                
                    ) AS total_expense,
                    
                    (
                        SELECT
                            count(*)
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = ' . $box_id . '
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                
                    ) AS transactions,
                    config_paymentmethod.bg_color,
                    config_paymentmethod.icon
                FROM
                    config_paymentmethod
                    WHERE config_paymentmethod.id <> ' . config('app.paymethod_quota') . '');
        } else {
            $query = DB::connection('tenant')
                ->select('SELECT
                    config_paymentmethod.description,
                (
                       SELECT
                            CASE
                            WHEN SUM(money_movements.amount) ISNULL THEN 0
                            ELSE SUM(money_movements.amount) 
                            END AS total
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = NULL
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS total,
                    (
                        SELECT
                            count(*)
                        FROM
                            money_movements
                        INNER JOIN money_concepts ON money_movements.concept_id = money_concepts.id
                        WHERE money_movements.paymentmethod_id = config_paymentmethod.id
                        AND money_movements.moneybox_id = NULL
                        AND DATE(money_movements.date_movement) = \'' . $date_now . '\'
                        AND money_movements.deleted_at ISNULL
                        AND money_concepts.typemovement_id = ' . config('app.tipo_movimiento_ingreso') . '
                
                    ) AS transactions,
                    config_paymentmethod.bg_color,
                    config_paymentmethod.icon
                FROM
                    config_paymentmethod
                    WHERE config_paymentmethod.id <> ' . config('app.paymethod_quota') .'');
        }


        return $query;
    }

    public function getBoxOpening()
    {
        $date_now = date('Y-m-d');
        $branchbox = $this->rBranchBox->getBranchBox();

        // VERIFIED IF NOT CLOSE THE LAST BOX
        $query = DB::connection('tenant')
            ->select('SELECT money_box.*, users.name as username FROM money_box
                            INNER JOIN users ON money_box.user_id = users.id
                            WHERE money_box.branchbox_id = ' . $branchbox . '
                            AND DATE(date_opening) <> \'' . $date_now . '\'
                            AND date_closing ISNULL');

        if (count($query) > 0) {
            $query[0]->is_before = true;
            return $query[0];
        } else {
            $query = DB::connection('tenant')
                ->select('SELECT money_box.*, users.name as username FROM money_box
                            INNER JOIN users ON money_box.user_id = users.id
                            WHERE money_box.branchbox_id = ' . $branchbox . '
                            AND DATE(date_opening) =  \'' . $date_now . '\'
                            AND money_box.date_closing ISNULL');
//
            if (count($query) == 0) {
                $query = false;
                return $query;
            } else {
                return $query[0];
            }
        }

    }

    public function create(array $attributes)
    {

    }

    public function openbox(array $attributes)
    {
        $branchbox = $this->rBranchBox->getBranchBox();;
        $item = new MoneyBox();
        $item->branchbox_id = $branchbox;
        $item->user_id = auth()->user()->id;
        $item->date_opening = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount_opening = $attributes['amount_opening'];
        $item->balance = $attributes['amount_opening'];
        $item->save();
        return $item;
    }

    public function closebox(array $attributes)
    {
        $item = $this->obj->find($attributes['id']);
        $item->date_closing = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount_closing = $attributes['balance'];
        $item->user_closebox = auth()->user()->id;
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        $query = $this->obj->find($id);
        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}