<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 29/07/2020
 * Time: 01:55 PM
 */

namespace App\Models\Tenant\Money\MoneyConcept;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class MoneyConceptRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new MoneyConcept();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function allConceptIncomes()
    {
        return $this->obj
            ->where('typemovement_id', config('app.tipo_movimiento_ingreso'))
            ->get();
    }

    public function allConceptExpenses()
    {
        return $this->obj
            ->where('typemovement_id', config('app.tipo_movimiento_egreso'))
            ->get();
    }

    public function create(array $attributes)
    {
        // TODO: Implement create() method.
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}