<?php

namespace App\Models\Tenant\Money\Movement;

use App\Core\ModelsCore;
use App\Models\Tenant\Billing\NoteDocument\NoteDocumentRepository;
use App\Models\Tenant\Config\PaymentMethod\PaymentMethodRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Movement extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'money_movements';

    protected $hidden = [
        'billing_response',
    ];


    protected $appends = ["paymethod", "note_document"];

    public function getpaymethodAttribute()
    {
        if (isset($this->attributes['paymentmethod_id'])) {
            $type = new PaymentMethodRepository();
            $data_type = $type->find($this->attributes['paymentmethod_id']);
            return $data_type['description'];
        }
    }

    public function getnoteDocumentAttribute()
    {
        $arr_note = array(
            "is_note_document" => false
        );
        $check_column = \Schema::connection("tenant")->hasColumn('money_movements','is_note_document');

         if($check_column == true){
            if(isset($this->attributes['is_note_document'])){
                if($this->attributes['is_note_document'] == true){
                    $note = new NoteDocumentRepository();
                    $rNote = $note->find($this->attributes['notedocument_id']);
                    $arr_note = array(
                        "is_note_document" => true,
                        "note_document_voucher"=> $rNote->nro_voucher
                    );
                }
            }
        }
        return $arr_note;
    }
}
