<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 22/07/2020
 * Time: 07:43 PM
 */

namespace App\Models\Tenant\Money\Movement;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class MovementRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Movement();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listMoneyMovements($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : 10;
        $model = $this->model();

        $date_now = date('Y-m-d');
        $data = $model
            ->leftJoin('purchase_providers', 'money_movements.provider_id', '=', 'purchase_providers.id')
            ->leftJoin('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->leftJoin('company_employees', 'money_movements.employee_id', '=', 'company_employees.id')
            ->leftJoin('sale_amortizations', 'money_movements.id', '=', 'sale_amortizations.moneymovement_id')
            ->leftJoin('sale_paid', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->leftJoin('sale_sales', 'sale_paid.sale_id', '=', 'sale_sales.id')
            ->leftJoin('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->join('money_concepts', 'money_movements.concept_id', '=', 'money_concepts.id')
            ->join('money_box', 'money_movements.moneybox_id', '=', 'money_box.id')
            ->join('branch_boxes', 'money_box.branchbox_id', '=', 'branch_boxes.id')
            ->join('config_paymentmethod', 'money_movements.paymentmethod_id', '=', 'config_paymentmethod.id')
            ->selectRaw("CASE
                        WHEN money_movements.client_id NOTNULL THEN 'CLIENTE'
                        WHEN money_movements.provider_id NOTNULL THEN 'PROVEEDOR'
                        WHEN money_movements.employee_id NOTNULL THEN 'EMPLEADO'
                        ELSE NULL
                    END as receptor_module,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.fullname
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.fullname
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.fullname
                    END as receptor_fullname,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.document
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.document
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.document
                    END as receptor_document,
                    CASE
                        WHEN money_movements.concept_id = ".config('app.moneyconcept_repayment_id')." THEN TRUE
                        WHEN money_movements.concept_id = ".config('app.moneyconcept_openbox')." THEN TRUE
                        WHEN money_movements.concept_id = ".config('app.moneyconcept_paycredit')." THEN TRUE
                        ELSE FALSE
                    END as is_repayment,
                    CASE
                        WHEN money_movements.concept_id = ".config('app.moneyconcept_openbox')." THEN TRUE
                        ELSE FALSE
                    END as is_initialbox,
                    CASE WHEN DATE(money_movements.date_movement) = '".$date_now."' THEN TRUE ELSE FALSE END as available_edit,
                    money_movements.*,
                    config_paymentmethod.description as paymethod,
                    money_concepts.description as concept,
                    config_typevoucher.description as typevoucher,
                    sale_sales.code as sale_code,
                    sale_sales.id as sale_id,
                    branch_boxes.description as branchbox")
            ->where('money_movements.branchoffice_id', $this->utilHelper->getBranchOffice());
 
        
        // $all_data = $data->get();
        $all_data = $data->count();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if ($text_search === 'null') {
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);

                $data = $data
                    ->where('money_movements.nro_voucher', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.document', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('company_employees.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('company_employees.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->count();
            }
            else{
                $data = $data->whereRaw("DATE(money_movements.date_movement) = '".$header['date_range']."'");
                $all_data = $data->count();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('money_movements.date_movement', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => $all_data,
            // 'total' => count($all_data),
            'paginate_by' => 10
        );

        return $response;
    }

    public function listVouchers($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $model
            ->join('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->join('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->join('sale_amortizations', 'money_movements.id', '=', 'sale_amortizations.moneymovement_id')
            ->join('sale_paid', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->join('sale_sales', 'sale_paid.sale_id', '=', 'sale_sales.id')
            ->selectRaw(
                "money_movements.*,
                DATE(money_movements.date_movement) as date_movement,
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                config_typedocument.description as typedocument,
                config_typevoucher.description as typevoucher,
                sale_sales.code as sale_code,
                sale_sales.id as sale_id,
                CASE WHEN money_movements.date_repayment ISNULL THEN 'Concretado' ELSE 'Anulado' END AS status")
            ->where('money_movements.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('money_movements.deleted_at', null);


        if($parameters != null) {
            if (isset($parameters['sunat_envio'])) {
                // check sunat envio
                if ($parameters['sunat_envio'] == config('app.sunat_pendiente')) {
                    $query = $query->where('money_movements.billing_external_id', null);
                } else if ($parameters['sunat_envio'] == config('app.sunat_enviado')) {
                    $query = $query->where('money_movements.billing_external_id', '!=', null);
                }
            }

            // check serie voucher

            if (isset($parameters['serie'])) {
                if($this->utilHelper->checkIsNullValue($parameters['serie'])!= null){
                    $query = $query->where('money_movements.serie', $parameters['serie']);
                }
            }


            // check status

            if (isset($parameters['status'])) {
                if ($parameters['status'] == config('app.voucher_concretado')) {
                    $query = $query->where('money_movements.date_repayment', null);
                } else if ($parameters['status'] == config('app.voucher_anulado')) {
                    $query = $query->where('money_movements.date_repayment', '!=', null);
                }
            }

            if (isset($parameters['voucher'])) {
                if($this->utilHelper->checkCeroToNull($parameters['voucher'])!= null){
                    $query = $query->where('money_movements.voucher_id', $parameters['voucher']);
                }
            }else{
                $query = $query->whereBetween('money_movements.voucher_id', [config('app.voucher_boleta_id'), config('app.voucher_factura_id')]);
            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);
                        $query = $query
                            ->where('money_movements.nro_voucher', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                    }
                }
            }

            if (isset($parameters['start_range'])) {
                $query = $query->whereRaw("DATE(money_movements.date_movement) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."'");
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('money_movements.date_movement', 'DESC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('money_movements.date_movement', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function listVouchersDetail($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $model
            ->join('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->join('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->join('config_currency', 'money_movements.currency_id', '=', 'config_currency.id')
            ->join('sale_amortizations', 'money_movements.id', '=', 'sale_amortizations.moneymovement_id')
            ->join('sale_paid', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->join('sale_sales', 'sale_paid.sale_id', '=', 'sale_sales.id')
            ->selectRaw(
                "date(money_movements.date_movement) as date_movement,
                money_movements.nro_voucher,
                money_movements.date_repayment,
                sale_clients.fullname as client,
                config_typedocument.description as type_document,
                sale_clients.document as nro_document,
                CONCAT(config_typedocument.description, ' : ', sale_clients.document) as client_document,
                config_currency.currency,
                money_movements.amount,
                ROUND((SELECT SUM(sale_detailsales.price * sale_detailsales.quantity) FROM sale_detailsales
	            WHERE sale_detailsales.sale_id = sale_sales.id AND sale_detailsales.igv > 0),2) AS affect_igv,
                ROUND(COALESCE((SELECT SUM(sale_detailsales.price * sale_detailsales.quantity) FROM sale_detailsales
	            WHERE sale_detailsales.sale_id = sale_sales.id AND sale_detailsales.igv = 0),0),2) AS no_affect_igv,
                ROUND((CASE WHEN sale_sales.igv = 0 THEN sale_sales.subtotal ELSE 0 END),2) AS total_exonerado,
                ROUND((((SELECT SUM(sale_detailsales.price * sale_detailsales.quantity) FROM sale_detailsales
                WHERE sale_detailsales.sale_id = sale_sales.id AND sale_detailsales.igv > 0)*18)/100),3) AS total_igv,
                -- (SELECT SUM(sale_detailsales.igv) FROM sale_detailsales WHERE sale_detailsales.sale_id = sale_sales.id) AS total_igv,
                sale_sales.total as total_sale
                ")
            ->where('money_movements.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('money_movements.deleted_at', null)
//            ->where('money_movements.date_repayment', '=',null)
            ->whereBetween('money_movements.voucher_id', [config('app.voucher_boleta_id'), config('app.voucher_factura_id')])
            ->orderBy('money_movements.date_movement', "DESC");

        if($parameters != null) {
            if (isset($parameters['sunat_envio'])) {
                // check sunat envio
                if ($parameters['sunat_envio'] == config('app.sunat_pendiente')) {
                    $query = $query->where('money_movements.billing_external_id', null);
                } else if ($parameters['sunat_envio'] == config('app.sunat_enviado')) {
                    $query = $query->where('money_movements.billing_external_id', '!=', null);
                }
            }

            // check serie voucher

            if (isset($parameters['serie'])) {
                if($this->utilHelper->checkIsNullValue($parameters['serie'])!= null){
                    $query = $query->where('money_movements.serie', $parameters['serie']);
                }
            }


            // check status

            if (isset($parameters['status'])) {
                if ($parameters['status'] == config('app.voucher_concretado')) {
                    $query = $query->where('money_movements.date_repayment', null);
                } else if ($parameters['status'] == config('app.voucher_anulado')) {
                    $query = $query->where('money_movements.date_repayment', '!=', null);
                }
            }

//            if (isset($parameters['voucher'])) {
//                if($this->utilHelper->checkCeroToNull($parameters['voucher'])!= null){
//                    $query = $query->where('money_movements.voucher_id', $parameters['voucher']);
//                }
//            }else{
//                $query = $query->whereBetween('money_movements.voucher_id', [config('app.voucher_boleta_id'), config('app.voucher_factura_id')]);
//            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);
                        $query = $query
                            ->where('money_movements.nro_voucher', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                    }
                }
            }

            if (isset($parameters['start_range'])) {
                $query = $query->whereRaw("DATE(money_movements.date_movement) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."'");
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('money_movements.date_movement', 'DESC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('money_movements.date_movement', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], $attributes['serie'], $branchoffice_id);

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->concept_id = config('app.moneyconcept_saleproduct_id');
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->client_id = $attributes['client_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['amount'];
        $item->text_amount = $attributes['text_amount']; // convert txt;
        $item->serie = $attributes['serie'];
        $item->reference_operation = $attributes['reference_operation'];
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        $item->save();
        return $item;
    }

    public function createRepaymentMovement($attributes)
    {
        $branchoffice_id = $this->utilHelper->getBranchOffice();

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->repaymentmovement_id = $attributes['repaymentmovement_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['amount'];
        $item->gloss = 'Reembolso de dinero del comprobante ' . $attributes['nro_voucher'];
        $item->concept_id = config('app.moneyconcept_repayment_id');
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->save();
        return $item;
    }

    public function createPurchaseMovement($attributes)
    {
        $branchoffice_id = $this->utilHelper->getBranchOffice();

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->provider_id = $attributes['provider_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['total'];
        $item->gloss = 'N° DE COMPRA - '.$attributes['code'].' VOUCHER : ' . $attributes['nro_voucher'];
        $item->concept_id = config('app.moneyconcept_paypurchase');
        $item->paymentmethod_id = config("app.paymethod_cash");;
        $item->save();
        return $item;
    }

    public function createMovementOpenBox($moneybox){
        $attributes['typevoucher_id'] = config('app.voucher_recibo_ingreso_id');
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], null, $branchoffice_id);

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $moneybox->id;
        $item->currency_id = config("app.currency_sol");
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $moneybox->amount_opening;
        $item->concept_id = config('app.moneyconcept_openbox');
        $item->paymentmethod_id = config("app.paymethod_cash");
        $item->serie = $get_correlative['serie']; // get serie
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        $item->save();
        return $item;

    }

    public function cancelledVoucher(array $attributes)
    {
        $item = $this->obj->find($attributes['movement_id']);
        $item->date_repayment = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->motive_cancelled = $attributes['motive_cancelled'];
        $item->save();
        return $item;
    }

    public function listIncome($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $date_now = date('Y-m-d');

        $data = $model
            ->leftJoin('purchase_providers', 'money_movements.provider_id', '=', 'purchase_providers.id')
            ->leftJoin('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->leftJoin('company_employees', 'money_movements.employee_id', '=', 'company_employees.id')
            ->join('money_concepts', 'money_movements.concept_id', '=', 'money_concepts.id')
            ->join('money_box', 'money_movements.moneybox_id', '=', 'money_box.id')
            ->join('branch_boxes', 'money_box.branchbox_id', '=', 'branch_boxes.id')
            ->join('config_paymentmethod', 'money_movements.paymentmethod_id', '=', 'config_paymentmethod.id')
            ->selectRaw("CASE
                        WHEN money_movements.client_id NOTNULL THEN 'CLIENTE'
                        WHEN money_movements.provider_id NOTNULL THEN 'PROVEEDOR'
                        WHEN money_movements.employee_id NOTNULL THEN 'EMPLEADO'
                        ELSE NULL
                    END as receptor_module,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.fullname
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.fullname
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.fullname
                    END as receptor_fullname,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.document
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.document
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.document
                    END as receptor_document,
                    CASE
                        WHEN money_movements.concept_id = ".config('app.moneyconcept_paycredit')." THEN TRUE
                        ELSE FALSE
                    END as is_paycredit,
                    CASE WHEN DATE(money_movements.date_movement) = '".$date_now."' THEN TRUE ELSE FALSE END as available_edit,
                    money_movements.*,
                    config_paymentmethod.description as paymethod,
                    money_concepts.description as concept,
                    branch_boxes.description as branchbox")
            ->where('money_movements.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('money_movements.voucher_id', config('app.voucher_recibo_ingreso_id'));

        $all_data = $model->all();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if ($text_search === 'null') {
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('money_movements.nro_voucher', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.document', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('company_employees.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('company_employees.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
            else{
                $data = $data->whereRaw("DATE(money_movements.date_movement) = '".$header['date_range']."'");
                $all_data = $data->get();
            }
        }

        $query = $data->where('concept_id','<>', config('app.moneyconcept_openbox'))->skip(($page - 1) * $limit)->take($limit)->orderBy('money_movements.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function listExpense($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $date_now = date('Y-m-d');

        $query = $model
            ->leftJoin('purchase_providers', 'money_movements.provider_id', '=', 'purchase_providers.id')
            ->leftJoin('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->leftJoin('company_employees', 'money_movements.employee_id', '=', 'company_employees.id')
            ->join('money_concepts', 'money_movements.concept_id', '=', 'money_concepts.id')
            ->join('money_box', 'money_movements.moneybox_id', '=', 'money_box.id')
            ->join('branch_boxes', 'money_box.branchbox_id', '=', 'branch_boxes.id')
            ->join('config_paymentmethod', 'money_movements.paymentmethod_id', '=', 'config_paymentmethod.id')
            ->join('users', 'money_movements.user_id', '=', 'users.id')
            ->join('config_currency', 'money_movements.currency_id', '=', 'config_currency.id')
            ->selectRaw("CASE
                        WHEN money_movements.client_id NOTNULL THEN 'CLIENTE'
                        WHEN money_movements.provider_id NOTNULL THEN 'PROVEEDOR'
                        WHEN money_movements.employee_id NOTNULL THEN 'EMPLEADO'
                        ELSE NULL
                    END as receptor_module,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.fullname
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.fullname
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.fullname
                    END as receptor_fullname,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.document
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.document
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.document
                    END as receptor_document,
                    CASE WHEN DATE(money_movements.date_movement) = '".$date_now."' THEN TRUE ELSE FALSE END as available_edit,
                    money_movements.*,
                    config_paymentmethod.description as paymethod,
                    money_concepts.description as concept,
                    users.username as username,
	                config_currency.currency,
                    branch_boxes.description as branchbox")
//            ->where('money_movements.deleted_at', null)
            ->where('money_movements.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('money_movements.voucher_id', config('app.voucher_recibo_egreso_id'));


        if($parameters != null) {

            // check is_voucher_external
            if (isset($parameters['is_voucher_external'])) {
                if($this->utilHelper->strToBooleanValue($parameters['is_voucher_external']) == true){
                    $query = $query->where('money_movements.is_voucher_external', true);
                }
            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);
                        $query = $query
                            ->where('money_movements.nro_voucher', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('purchase_providers.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('purchase_providers.document', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('company_employees.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('company_employees.document', 'LIKE', '%' . $text_search . '%');
                    }
                }
            }

            if (isset($parameters['start_range'])) {
                $query = $query->whereRaw("DATE(money_movements.date_movement) BETWEEN '".$parameters['start_range']."' AND '".$parameters['end_range']."'");
            }
            else{
                $query = $query->whereRaw("DATE(money_movements.date_movement) = '".$parameters['date_range']."'");
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('money_movements.date_movement', 'DESC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('money_movements.date_movement', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }


    public function listMovementAccountBank($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $accountbank = $header->has('accountbank') ? $header->get('accountbank') : null;
        $model = $this->model();

        $data = $model
            ->leftJoin('purchase_providers', 'money_movements.provider_id', '=', 'purchase_providers.id')
            ->leftJoin('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->leftJoin('company_employees', 'money_movements.employee_id', '=', 'company_employees.id')
            ->join('money_concepts', 'money_movements.concept_id', '=', 'money_concepts.id')
            ->join('finance_accountbanks', 'money_movements.accountbank_id', '=', 'finance_accountbanks.id')
            ->selectRaw("finance_accountbanks.name,
	                    money_concepts.description as concept_description,
	                    CASE
                            WHEN money_concepts.typemovement_id = 1 THEN 'Ingreso'
                            ELSE 'Egreso'
                        END as description_typemovement,
                        CASE
                            WHEN money_concepts.typemovement_id = 1 THEN 'text-success fas fa-arrow-right'
                            ELSE 'text-danger fas fa-arrow-left'
                         END as icon_typemovement,
                        CASE
                            WHEN money_movements.client_id NOTNULL THEN 'CLIENTE'
                            WHEN money_movements.provider_id NOTNULL THEN 'PROVEEDOR'
                            WHEN money_movements.employee_id NOTNULL THEN 'EMPLEADO'
                            ELSE NULL
                        END as receptor_module,
                        CASE
                            WHEN money_movements.client_id NOTNULL THEN sale_clients.fullname
                            WHEN money_movements.provider_id NOTNULL THEN purchase_providers.fullname
                            WHEN money_movements.employee_id NOTNULL THEN company_employees.fullname
                        END as receptor_fullname,
                        CASE
                            WHEN money_movements.client_id NOTNULL THEN sale_clients.document
                            WHEN money_movements.provider_id NOTNULL THEN purchase_providers.document
                            WHEN money_movements.employee_id NOTNULL THEN company_employees.document
                        END as receptor_document,
	                    money_movements.*")
            ->where('money_movements.deleted_at', null);

        if($this->utilHelper->checkIsNullValue($accountbank) != null){
            $data = $data->where('money_movements.accountbank_id', $accountbank);
        }

        $all_data = $data->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if ($text_search === 'null') {
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('money_movements.reference_operation', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.document', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('company_employees.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('company_employees.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
            else{
                $data = $data->whereBetween('money_movements.date_movement', [$header['start_range'], $header['end_range']]);
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('money_movements.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by'),
//            'sum_incomes'=>$data->where('money_concepts.typemovement_id', 1)->sum('amount'),
//            'sum_expenses'=>$data->where('money_concepts.typemovement_id', 2)->sum('amount')
        );

        return $response;
    }

    public function saveIncome(array $attributes)
    {
        $attributes['typevoucher_id'] = config('app.voucher_recibo_ingreso_id');
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], null, $branchoffice_id);

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->concept_id = $attributes['concept_id'];
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->client_id = $attributes['client_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['amount'];
        $item->gloss = $attributes['gloss'];
        $item->serie = $get_correlative['serie']; // get serie
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        $item->save();
        return $item;
    }

    public function saveAmortizationBooking(array $attributes)
    {
        $attributes['typevoucher_id'] = config('app.voucher_recibo_ingreso_id');
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], null, $branchoffice_id);

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->client_id = $attributes['client_id'];
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->concept_id = config('app.moneyconcept_amortization_booking');
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['amount'];
        $item->gloss = $attributes['gloss'];
        $item->serie = $get_correlative['serie']; // get serie
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        // hotels booking
        $item->hotelbooking_id = $attributes['booking_id'];
        $item->save();

        return $item;
    }

    public function saveExpense(array $attributes)
    {
        $attributes['typevoucher_id'] = config('app.voucher_recibo_egreso_id');
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], null, $branchoffice_id);

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->concept_id = $attributes['concept_id'];
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->provider_id = $attributes['provider_id'];
        $item->client_id = $attributes['client_id'];
        $item->employee_id = $attributes['employee_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['amount'];
        $item->gloss = $attributes['gloss'];
        $item->reference_operation = $attributes['reference_operation'];
        $item->serie = $get_correlative['serie']; // get serie
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative

        if ($this->utilHelper->strToBooleanValue($attributes['is_voucher_external']) == true) {
            $item->is_voucher_external = true;
            $item->voucher_external = $attributes['voucher_external'];
            $item->nro_voucher_external = $attributes['nro_voucher_external'];
        }

        $item->save();
        return $item;
    }

    public function getMovementByHotelBooking($booking_id){
        $query = $this->obj
            ->join('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->join('config_paymentmethod', 'money_movements.paymentmethod_id', '=', 'config_paymentmethod.id')
            ->select('money_movements.*',
                'money_movements.amount as total_amount',
                'config_typevoucher.description as typevoucher',
                'config_paymentmethod.description as paymethod')
            ->where('money_movements.hotelbooking_id', $booking_id)
            ->where('money_movements.deleted_at', null)
            ->orderBy('money_movements.date_movement', 'ASC')
            ->get();

        return $query;
    }


    public function saveAmortizationCharge(array $attributes)
    {
        $attributes['typevoucher_id'] = config('app.voucher_recibo_ingreso_id');
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], null, $branchoffice_id);

        $item = new Movement();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $branchoffice_id;
        $item->moneybox_id = $attributes['moneybox_id'];
        $item->concept_id = config('app.moneyconcept_paycredit');
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->client_id = $attributes['client_id'];
        $item->date_movement = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->amount = $attributes['amount'];
        $item->gloss = $attributes['gloss'];
        $item->serie = $get_correlative['serie']; // get serie
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function updatedExpense($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->concept_id = $attributes['concept_id'];
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->provider_id = $attributes['provider_id'];
        $item->client_id = $attributes['client_id'];
        $item->employee_id = $attributes['employee_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->gloss = $attributes['gloss'];
        $item->reference_operation = $attributes['reference_operation'];

        if ($this->utilHelper->strToBooleanValue($attributes['is_voucher_external']) == true) {
            $item->is_voucher_external = true;
            $item->voucher_external = $attributes['voucher_external'];
            $item->nro_voucher_external = $attributes['nro_voucher_external'];
        }

        $item->save();

        return $item;
    }

    public function updatedIncome($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->concept_id = $attributes['concept_id'];
        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->provider_id = $attributes['provider_id'];
        $item->client_id = $attributes['client_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->gloss = $attributes['gloss'];
        $item->save();

        return $item;
    }

    public function findJoined($id)
    {
        $date_now = date('Y-m-d');

        $query = $this->obj
            ->leftJoin('purchase_providers', 'money_movements.provider_id', '=', 'purchase_providers.id')
            ->leftJoin('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->leftJoin('company_employees', 'money_movements.employee_id', '=', 'company_employees.id')
            ->selectRaw("CASE
                        WHEN money_movements.client_id NOTNULL THEN 'CLIENTE'
                        WHEN money_movements.provider_id NOTNULL THEN 'PROVEEDOR'
                        WHEN money_movements.employee_id NOTNULL THEN 'EMPLEADO'
                        ELSE NULL
                    END as receptor_module,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.fullname
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.fullname
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.fullname
                    END as receptor_fullname,
                    CASE
                        WHEN money_movements.client_id NOTNULL THEN sale_clients.document
                        WHEN money_movements.provider_id NOTNULL THEN purchase_providers.document
                        WHEN money_movements.employee_id NOTNULL THEN company_employees.document
                    END as receptor_document,
                    CASE WHEN DATE(money_movements.date_movement) = '".$date_now."' THEN TRUE ELSE FALSE END as available_edit,
                    money_movements.*")
            ->where('money_movements.id', $id)
            ->first();

        return $query;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function getMovementSaleJoinAmortization($movement_id)
    {
        $query = $this->obj
            ->join('sale_amortizations', 'money_movements.id', '=', 'sale_amortizations.moneymovement_id')
            ->join('sale_paid', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->select('sale_paid.sale_id as sale_id')
            ->where('money_movements.id', $movement_id)
            ->first();
        return $query;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
        return $item;
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }


    public function rowExportVouchers($parameters)
    {
        $data = $this->obj
            ->join('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->join('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->selectRaw(
                "money_movements.*,
                DATE(money_movements.date_movement) as date_movement,
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                config_typedocument.description as typedocument,
                config_typevoucher.description as typevoucher,
                CASE WHEN money_movements.date_repayment ISNULL THEN 'Concretado' ELSE 'Anulado' END AS status")
            ->where('money_movements.deleted_at', null)
            ->whereBetween('money_movements.date_movement', [$parameters['start_range'], $parameters['end_range']])
            ->orderBy('money_movements.date_movement', 'DESC');

        // check voucher
        if ($parameters['voucher'] == 'null') {
            $data = $data->whereBetween('money_movements.voucher_id', [1, 2]);
        } else {
            $data = $data->where('money_movements.voucher_id', $parameters['voucher']);
        }

        // check status
        if ($parameters['status'] == config('app.voucher_concretado')) {
            $data = $data->where('money_movements.date_repayment', null);
        } else if($parameters['status'] == config('app.voucher_anulado')){
            $data = $data->where('money_movements.date_repayment', '!=',null);
        }

        return $data->get();
    }

    public function arqueo($moneybox){

        $data = $this->obj
            ->leftjoin('sale_clients', 'money_movements.client_id', '=', 'sale_clients.id')
            ->leftjoin('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->leftjoin('purchase_providers', 'money_movements.provider_id', '=', 'purchase_providers.id')
            ->leftjoin('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->leftjoin('finance_accountbanks', 'money_movements.accountbank_id', '=', 'finance_accountbanks.id')
            ->leftjoin('finance_banks', 'finance_accountbanks.bank_id', '=', 'finance_banks.id')
            ->join('money_concepts', 'money_movements.concept_id', '=', 'money_concepts.id')
            ->join('config_paymentmethod', 'money_movements.paymentmethod_id', '=', 'config_paymentmethod.id')
            ->selectRaw(
                "cast(money_movements.date_movement::timestamp as time) as date_hour,
                money_concepts.description as concept,
                money_movements.paymentmethod_id as paymentmethod_id,
                money_movements.gloss as gloss,
                money_movements.reference_operation as reference_operation,
                CASE
                    WHEN money_movements.accountbank_id NOTNULL THEN concat(finance_banks.description, ' - ', finance_accountbanks.name)
                    ELSE '-'
                    END as accountbank,
                CASE
                    WHEN money_movements.voucher_id NOTNULL THEN concat(config_typevoucher.description, ' - ', money_movements.nro_voucher)
                    WHEN money_movements.voucher_id ISNULL THEN money_movements.gloss
                    ELSE '-'
                    END as voucher,
                CASE
                    WHEN money_movements.client_id NOTNULL THEN concat(sale_clients.fullname,' - ', config_typedocument.description,':', sale_clients.document)
                    WHEN money_movements.provider_id NOTNULL THEN concat(purchase_providers.fullname, ' - RUC:', purchase_providers.document)
                    ELSE '-'
                END AS reference_person,
                config_paymentmethod.description as paymentmethod,
                CASE
                    WHEN money_concepts.typemovement_id = ".config('app.tipo_movimiento_ingreso')." AND config_paymentmethod.id != ".config('app.paymethod_quota')." THEN money_movements.amount ELSE null END as income,
                CASE
                    WHEN money_concepts.typemovement_id = ".config('app.tipo_movimiento_egreso')." AND config_paymentmethod.id != ".config('app.paymethod_quota')." THEN money_movements.amount ELSE null END as expense,
                CASE
                    WHEN money_concepts.typemovement_id = ".config('app.tipo_movimiento_ingreso')." AND config_paymentmethod.id = ".config('app.paymethod_quota')." THEN money_movements.amount ELSE null END as credit")
            ->where('money_movements.deleted_at', null)
            ->where("money_movements.moneybox_id", $moneybox->id)
            ->orderBy('money_movements.date_movement', 'ASC')
            ->get();

        return $data;
    }

    public function averagePriceProductWarehouseDetail($parameters = null){
        $query = array();

        if($parameters != null){
            $branchoffice = "";
            if (isset($parameters['branchoffice'])) {
                if($parameters['branchoffice'] != 'null')
                    $branchoffice = " AND warehouse_movements.branchoffice_id = ".$parameters['branchoffice'];
            }

            $query = DB::connection('tenant')
                ->select("SELECT
                            catalog_products.id,
                            catalog_products.description,
                            (SUM(warehouse_detailmovements.price) / COUNT(warehouse_detailmovements.id)) as average_purchase,
	                        ((SUM(warehouse_detailmovements.price) / COUNT(warehouse_detailmovements.id))*catalog_productstock.stock) as total_merchandise
                        FROM
                            catalog_products
                        INNER JOIN warehouse_detailmovements ON catalog_products.ID = warehouse_detailmovements.product_id
                        INNER JOIN warehouse_movements ON warehouse_detailmovements.warehousemovement_id = warehouse_movements.id
                        INNER JOIN catalog_productstock ON catalog_products.id = catalog_productstock.product_id
                        WHERE warehouse_movements.deleted_at ISNULL
                        AND catalog_products.type_product = '1'
                        ".$branchoffice."
                        AND catalog_productstock.stock > 0
                        AND catalog_products.deleted_at ISNULL
                        GROUP BY catalog_products.id, catalog_productstock.stock
                        ORDER BY catalog_products.id ASC");
        }

        return $query;
    }
}
