<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 28/10/2020
 * Time: 09:15 AM
 */

namespace App\Models\Tenant\Purchase\OrderDetailPurchase;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class OrderDetailPurchaseRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new OrderDetailPurchase();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new OrderDetailPurchase();
        $item->order_id = $attributes['order_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->equivalence = $attributes['equivalence'];
        $item->detail = $attributes['detail'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function findByOrderIdAndProductId($order_id, $product_id){
        $query = $this->obj
            ->where('purchase_detailorders.product_id', $product_id)
            ->where('purchase_detailorders.order_id', $order_id)
            ->first();

        return $query;
    }

    public function findByOrderId($order_id){
        $query = $this->obj
            ->where('purchase_detailorders.deleted_at', null)
            ->where('purchase_detailorders.order_id', $order_id)
            ->get();

        return $query;
    }

    public function findByOrderIdJoined($order_id)
    {
        return $this->obj
            ->join('catalog_products', 'purchase_detailorders.product_id', '=', 'catalog_products.id')
            ->join('config_unitsofmeasure', 'purchase_detailorders.unitmeasure_id', '=', 'config_unitsofmeasure.id')
            ->select('purchase_detailorders.*',
                'catalog_products.description as description',
                'config_unitsofmeasure.description as unitmeasure',
                'purchase_detailorders.id as detail_id',
                'purchase_detailorders.product_id as id',
                DB::raw('(purchase_detailorders.quantity * purchase_detailorders.price) as subtotal, 
                (purchase_detailorders.quantity * purchase_detailorders.price + purchase_detailorders.igv) as total'))
            ->where('purchase_detailorders.deleted_at', null)
            ->where('purchase_detailorders.order_id', $order_id)
            ->get();
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}