<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 28/10/2020
 * Time: 09:07 AM
 */

namespace App\Models\Tenant\Purchase\OrderPurchase;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class OrderPurchaseRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new OrderPurchase();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listOrder($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $statusDelivered = $header->has('statusDelivered') ? $this->utilHelper->strToBooleanValue($header->get('statusDelivered')) : false;
        $model = $this->model();

        $user = auth()->user();

        $data = $model
            ->join('users', 'purchase_orders.user_id', '=', 'users.id')
            ->join('purchase_providers', 'purchase_orders.provider_id', '=', 'purchase_providers.id')
            ->select('purchase_orders.*',
                'purchase_providers.fullname as provider_fullname',
                'purchase_providers.document as provider_document'
            )
            ->where('purchase_orders.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('purchase_orders.deleted_at', null);
//            ->where('purchase_orders.is_delivered', $statusDelivered);

        $all_data = $data->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data->where('purchase_orders.code', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_orders.observation', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('purchase_providers.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('purchase_orders.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $get_correlative = $this->utilHelper->createOrderPurchaseCorrelative();
        $item = new OrderPurchase();
        $item->user_id = auth()->user()->id;
        $item->provider_id = $attributes['provider_id'];
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->nro_voucher = $attributes['nro_voucher'];
        $item->code = $get_correlative['code'];
        $item->correlative = $get_correlative['correlative'];
        $item->date_order = $attributes['date_order'];
        $item->observation = $attributes['observation'];
        $item->delivery_terms = $attributes['delivery_terms'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->text_amount = $attributes['text_amount'];
        $item->save();
        return $item;

    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->provider_id = $attributes['provider_id'];
        $item->date_order = $attributes['date_order'];
        $item->observation = $attributes['observation'];
        $item->delivery_terms = $attributes['delivery_terms'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->text_amount = $attributes['text_amount'];
        $item->save();
        return $item;
    }

    public function getOrderLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('deleted_at', null)
            ->orderBy('id', 'desc')
            ->first();

        return $item;
    }

    public function find($id)
    {

    }

    public function findJoined($id)
    {
        $item = $this->obj
            ->join('purchase_providers', 'purchase_orders.provider_id', '=', 'purchase_providers.id')
            ->selectRaw("
                purchase_orders.*,
                purchase_providers.fullname as provider_fullname, 
                purchase_providers.document as provider_document
            ")
            ->where('purchase_orders.deleted_at', null)
            ->where('purchase_orders.id', $id)
            ->first();

        return $item;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}