<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 10/07/2020
 * Time: 05:25 PM
 */

namespace App\Models\Tenant\Purchase\Provider;

use App\Helper\HelperChecker;
use App\Helper\StorageHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class ProviderRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;
    protected $storageHelper;

    public function __construct()
    {
        $this->obj = new Provider();
        $this->helperChecker = new HelperChecker();
        $this->storageHelper = new StorageHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listProviders($parameters = null, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');

        $query = $this->obj
            ->select("purchase_providers.*")
            ->where('purchase_providers.deleted_at', null);

        if($parameters != null){

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('purchase_providers.fullname', 'like', '%' . $text_search . '%')
                                ->orWhere('purchase_providers.document', 'like', '%' . $text_search . '%');
                        });
                    }
                }
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('purchase_providers.id', 'DESC')->get();
        }
        else{
            $query = $query
                ->skip(($page - 1) * $limit)
                ->take($limit)
                ->orderBy('purchase_providers.id', 'DESC')->get()->toArray();
        }


        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $type_ruc = config('app.typedocument_ruc');
        $this->helperChecker->checkProviderDocument($attributes['document']);
        $this->helperChecker->checkDocumentLengthByTypeDocument($attributes['document'], $type_ruc);

        $item = new Provider();
        $item->fullname = $attributes['fullname'];
        $item->document = $attributes['document'];
        $item->tradename = $attributes['tradename'];
        $item->telephone = $attributes['telephone'];
        $item->cellphone = $attributes['cellphone'];
        $item->email = $attributes['email'];
        $item->address = $attributes['address'];
        $item->url_image = null;
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);

        $type_ruc = config('app.typedocument_ruc');
        $this->helperChecker->checkProviderDocumentUpdate($attributes['document'], $item->id);
        $this->helperChecker->checkDocumentLengthByTypeDocument($attributes['document'], $type_ruc);

        $item->fullname = $attributes['fullname'];
        $item->document = $attributes['document'];
        $item->tradename = $attributes['tradename'];
        $item->telephone = $attributes['telephone'];
        $item->cellphone = $attributes['cellphone'];
        $item->email = $attributes['email'];
        $item->address = $attributes['address'];
        $item->url_image = null;
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function saveUrlImage($item, $attributes)
    {
        $image = $attributes['url_image'];
        if ($image != null) {
            $file_url = $this->storageHelper->saveUrlImgProvider($attributes);
            $item->url_image = $file_url;
            $item->save();
        }
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);

        return $this->obj
            ->select('purchase_providers.id as id', 'fullname', DB::raw("concat('RUC : ' , purchase_providers.document) AS document"))
            ->where('purchase_providers.deleted_at', null)
            ->where('fullname', 'LIKE', '%' . $text_search . '%')
            ->orwhere('document', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}