<?php

namespace App\Models\Tenant\Purchase\Purchase;

use App\Core\ModelsCore;
use App\Models\Tenant\Config\Currency\CurrencyRepository;
use App\Models\Tenant\Config\TypeTransaction\TypeTransactionRepository;
use App\Models\Tenant\Config\TypeVoucher\TypeVoucherRepository;
use App\Models\Tenant\Purchase\Provider\ProviderRepository;
use App\Models\Tenant\Warehouse\Warehouse\WarehouseRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Purchase extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'purchase_purchases';

    protected $appends = ["provider", "typevoucher", "typetransaction", "warehouse_description", "currency", "provider_data"];

    public function getproviderAttribute()
    {
        if (isset($this->attributes['provider_id'])) {
            $provider = new ProviderRepository();
            $description = $provider->find($this->attributes['provider_id']);
            return $description['fullname'];
        }
    }

    public function gettypevoucherAttribute()
    {
        if (isset($this->attributes['typevoucher_id'])) {
            $item = new TypeVoucherRepository();
            $description = $item->find($this->attributes['typevoucher_id']);
            return $description['description'];
        }
    }

    public function getcurrencyAttribute()
    {
        if (isset($this->attributes['currency_id'])) {
            $item = new CurrencyRepository();
            $description = $item->find($this->attributes['currency_id']);
            return $description['description'];
        }
    }

    public function gettypetransactionAttribute()
    {
        if (isset($this->attributes['typetransaction_id'])) {
            $item = new TypeTransactionRepository();
            $description = $item->find($this->attributes['typetransaction_id']);
            return $description['description'];
        }
    }

    public function getwarehouseDescriptionAttribute()
    {
        if (isset($this->attributes['warehouse_id'])) {
            $warehouse = new WarehouseRepository();
            $description = $warehouse->find($this->attributes['warehouse_id']);
            return $description['description'];
        }
    }


    public function getproviderDataAttribute()
    {
        if (isset($this->attributes['provider_id'])) {
            $client= new ProviderRepository();
            $data = $client->find($this->attributes['provider_id']);
            return $data;
        }
    }
}
