<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 15/07/2020
 * Time: 01:47 AM
 */

namespace App\Models\Tenant\Purchase\Purchase;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class PurchaseRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Purchase();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listPurchase($parameters, $export = false){

        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $model
            ->join('purchase_providers', 'purchase_purchases.provider_id', '=', 'purchase_providers.id')
            ->join('config_typevoucher', 'purchase_purchases.typevoucher_id', '=', 'config_typevoucher.id')
            ->selectRaw(
                "purchase_purchases.*,
                DATE(purchase_purchases.date_purchase) as date_purchase,
                purchase_providers.fullname as provider,
                purchase_providers.document as provider_document,
                config_typevoucher.description as typevoucher,
                CASE WHEN purchase_purchases.deleted_at ISNULL THEN 'Concretado' ELSE 'Anulado' END AS status")
            ->where('purchase_purchases.branchoffice_id', $this->utilHelper->getBranchOffice());

        if($parameters != null) {

            // check status
            if (isset($parameters['status'])) {
                if ($parameters['status'] == config('app.voucher_concretado')) {
                    $query = $query->where('purchase_purchases.deleted_at', null);
                } else if ($parameters['status'] == config('app.voucher_anulado')) {
                    $query = $query->where('purchase_purchases.deleted_at', '!=', null);
                }
            }

            if (isset($parameters['voucher'])) {
                if($this->utilHelper->checkCeroToNull($parameters['voucher'])!= null){
                    $query = $query->where('purchase_purchases.typevoucher_id', $parameters['voucher']);
                }
            }

            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);
                        $query = $query
                            ->where('code', 'LIKE', '%'. $text_search.'%')
                            ->orwhere('purchase_providers.fullname', 'LIKE', '%' . $text_search . '%')
                            ->orwhere('purchase_providers.document', 'LIKE', '%' . $text_search . '%');
                    }
                }
            }

            if (isset($parameters['start_range'])) {
                $query = $query->whereBetween('purchase_purchases.date_purchase', [$parameters['start_range'], $parameters['end_range']]);
            }
        }

        $all_data = $query->get();

        if($export){
            $query = $query->orderBy('purchase_purchases.id', 'DESC')->get();
        }
        else{
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('purchase_purchases.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function listPendingPayments($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $data = $model
            ->join('purchase_paid', 'purchase_purchases.id', '=', 'purchase_paid.purchase_id')
            ->join('purchase_schedule', 'purchase_purchases.id', '=', 'purchase_schedule.purchase_id')
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->selectRaw("sale_sales.*,
                sale_paid.*,
                sale_sales.id as id,
                sale_clients.fullname as client, 
                sale_clients.document as client_document,
                config_typedocument.description as typedocument,
                (SELECT sale_detailschedule.date_assigned FROM sale_detailschedule
                WHERE sale_detailschedule.schedule_id = sale_schedule.id 
                AND sale_detailschedule.is_paid = false
                ORDER BY sale_detailschedule.date_assigned ASC LIMIT 1) as nextdateschedule")
            ->whereRaw('sale_paid.total_amount != sale_paid.total_paid')
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_sales.deleted_at', null);

        $all_data = $model
            ->join('sale_paid', 'sale_sales.id', '=', 'sale_paid.sale_id')
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->select('sale_sales.*',
                'sale_paid.*',
                'sale_sales.id as id',
                'sale_clients.fullname as client',
                'sale_clients.document as client_document',
                'config_typedocument.description as typedocument'
            )
            ->whereRaw('sale_paid.total_amount != sale_paid.total_paid')
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_sales.deleted_at', null)
            ->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('code', 'LIKE', '%'. $text_search.'%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('nextdateschedule', 'ASC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $get_correlative = $this->utilHelper->createPurchaseCorrelative();

        $item = new Purchase();
        $item->user_id = auth()->user()->id;
        $item->provider_id = $attributes['provider_id'];
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->typetransaction_id = $attributes['typetransaction_id'];
        $item->currency_id = $attributes['currency_id'];
        $item->typevoucher_id = $attributes['typevoucher_id'];
        $item->nro_voucher = $attributes['nro_voucher'];
        $item->code = $get_correlative['code'];
        $item->correlative = $get_correlative['correlative'];
        $item->date_purchase = $attributes['date_purchase'];
        $item->exchange_currency = $attributes['exchange_currency'];
        $item->nro_guidereference = $attributes['nro_guidereference'];
        $item->observation = $attributes['observation'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->affect_moneybox = $attributes['affect_moneybox'];
        $item->status_paid = 'C';

        $item->paymentmethod_id = $attributes['paymentmethod_id'];
        $item->accountbank_id = $attributes['accountbank_id'];


        if (isset($attributes['reference_operation'])){
            $check_column = \Schema::connection("tenant")->hasColumn('purchase_purchases','reference_operation');
            if($check_column){
                $item->reference_operation = $attributes['reference_operation'];
            }
        }

        $item->save();
        return $item;
    }

    public function getPurchaseLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('deleted_at', null)
            ->orderBy('id', 'desc')
            ->first();

        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }

    public function rowExportPurchases($parameters)
    {
        $data = $this->obj
            ->join('purchase_providers', 'purchase_purchases.provider_id', '=', 'purchase_providers.id')
            ->join('config_typevoucher', 'purchase_purchases.typevoucher_id', '=', 'config_typevoucher.id')
            ->selectRaw(
                "purchase_purchases.*,
                DATE(purchase_purchases.date_purchase) as date_purchase,
                purchase_providers.fullname as provider,
                purchase_providers.document as provider_document,
                config_typevoucher.description as typevoucher,
                CASE WHEN purchase_purchases.deleted_at ISNULL THEN 'Concretado' ELSE 'Anulado' END AS status")
//            ->where('purchase_purchases.deleted_at', null)
            ->where('purchase_purchases.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->whereBetween('purchase_purchases.date_purchase', [$parameters['start_range'], $parameters['end_range']]);

        // check voucher
        if (isset($parameters['voucher'])) {
            if($parameters['voucher'] != 'null')
                $data = $data->where('purchase_purchases.typevoucher_id', $parameters['voucher']);
        }

        // check provider
        if(isset($parameters['provider'])){
            if ($parameters['provider'] != 'null')
                $data = $data->where('purchase_purchases.provider_id', $parameters['provider']);
        }

//         check status
        if ($parameters['status'] == config('app.voucher_concretado')) {
            $data = $data->where('purchase_purchases.deleted_at', null);
        } else if($parameters['status'] == config('app.voucher_anulado')){
            $data = $data->where('purchase_purchases.deleted_at', '!=',null);
        }

        return $data->orderBy('purchase_purchases.date_purchase', 'DESC')->get();
    }

    public function averagePriceProductPurchaseDetail($parameters = null){
        $query = array();

        if($parameters != null){
            $branchoffice = "";
            if (isset($parameters['branchoffice'])) {
                if($parameters['branchoffice'] != 'null')
                    $branchoffice = " AND purchase_purchases.branchoffice_id = ".$parameters['branchoffice'];
            }

            $query = DB::connection('tenant')
                ->select("SELECT
                            catalog_products.id,
                            catalog_products.description,
                            (SUM(purchase_detailpurchases.price) / COUNT(purchase_detailpurchases.id)) as average_purchase,
	                        ((SUM(purchase_detailpurchases.price) / COUNT(purchase_detailpurchases.id))*catalog_productstock.stock) as total_merchandise
                        FROM
                            catalog_products
                        INNER JOIN purchase_detailpurchases ON catalog_products. ID = purchase_detailpurchases.product_id
                        INNER JOIN purchase_purchases ON purchase_detailpurchases.purchase_id = purchase_purchases.id
                        INNER JOIN catalog_productstock ON catalog_products.id = catalog_productstock.product_id
                        WHERE purchase_purchases.deleted_at ISNULL
                        AND catalog_products.type_product = '1'
                        ".$branchoffice." 
                        AND catalog_productstock.stock > 0
                        AND catalog_products.deleted_at ISNULL
                        GROUP BY catalog_products.id, catalog_productstock.stock
                        ORDER BY catalog_products.id ASC");
        }

        return $query;
    }
}