<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 15/07/2020
 * Time: 01:49 AM
 */

namespace App\Models\Tenant\Purchase\PurchaseDetail;


use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class PurchaseDetailRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new PurchaseDetail();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new PurchaseDetail();
        $item->purchase_id = $attributes['purchase_id'];
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];

        if (isset($attributes['is_igv'])){
            $check_column = \Schema::connection("tenant")->hasColumn('purchase_detailpurchases','is_igv');
            if($check_column)
                $item->is_igv = $attributes['is_igv'];
        }

        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findByPurchaseIdJoined($purchase_id)
    {
        return $this->obj
            ->join('catalog_products', 'purchase_detailpurchases.product_id', '=', 'catalog_products.id')
            ->join('config_unitsofmeasure', 'purchase_detailpurchases.unitmeasure_id', '=', 'config_unitsofmeasure.id')
            ->leftjoin('catalog_productbatch', 'purchase_detailpurchases.productbatch_id', '=', 'catalog_productbatch.id')
            ->select('purchase_detailpurchases.*',
                'catalog_products.description as description',
                'catalog_productbatch.date_expiration as date_expiration',
                'config_unitsofmeasure.description as unitmeasure',
                'purchase_detailpurchases.id as detail_id',
                'purchase_detailpurchases.product_id as id',
                DB::raw('(purchase_detailpurchases.quantity * purchase_detailpurchases.price) as subtotal, 
                (purchase_detailpurchases.quantity * purchase_detailpurchases.price + purchase_detailpurchases.igv) as total'))
            ->where('purchase_detailpurchases.deleted_at', null)
            ->where('purchase_detailpurchases.purchase_id', $purchase_id)
            ->get();
    }

    public function averagePricePurchaseProduct($prduct_id){
        $query = $this->obj
            ->join('purchase_purchases', 'purchase_detailpurchases.purchase_id', '=', 'purchase_purchases.id')
            ->selectRaw("
            (SUM(purchase_detailpurchases.price * purchase_detailpurchases.quantity))/
            (SUM(purchase_detailpurchases.quantity * ( CASE WHEN purchase_detailpurchases.equivalence ISNULL THEN 1 ELSE purchase_detailpurchases.equivalence END))) as average_price")
            ->where('purchase_detailpurchases.product_id', $prduct_id)
            ->where('purchase_detailpurchases.deleted_at', null)
            ->where('purchase_purchases.deleted_at', null)
            ->first();

        return $query;
    }

    public function lastPricePurchaseProduct($prduct_id){
        $query = $this->obj
            ->join('purchase_purchases', 'purchase_detailpurchases.purchase_id', '=', 'purchase_purchases.id')
            ->join('purchase_providers', 'purchase_purchases.provider_id', '=', 'purchase_providers.id')
            ->selectRaw("
                purchase_providers.fullname as provider,
                purchase_purchases.date_purchase,
                purchase_detailpurchases.*
            ")
            ->where('purchase_detailpurchases.product_id', $prduct_id)
            ->where('purchase_purchases.deleted_at', null)
            ->where('purchase_detailpurchases.deleted_at', null)
            ->orderBy('purchase_detailpurchases.created_at', "DESC")
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}