<?php

namespace App\Models\Tenant\Restaurant\CategoryFood;

use App\Core\ModelsCore;
use App\Helper\StorageHelper;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class CategoryFood extends ModelsCore
{
    use UsesTenantConnection;

    protected $storageHelper;
    protected $table = 'restaurant_categoryfoods';

    protected $appends = ["urlImageBase"];

    public function __construct()
    {
        $this->storageHelper = new StorageHelper();
    }

    public function geturlImageBaseAttribute()
    {
        if (isset($this->attributes['url_image'])) {
            $url_image = $this->attributes['url_image'];
            if ($url_image != null or $url_image != '') {
                $url_image = $this->storageHelper->getUrlImgCategoryFood($url_image);
            }
            return $url_image;
        }
    }
}
