<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 17/12/2020
 * Time: 10:15 AM
 */

namespace App\Models\Tenant\Restaurant\CategoryFood;


use App\Helper\HelperChecker;
use App\Helper\StorageHelper;
use App\Models\Contract\BaseRepositoryInterface;

class CategoryFoodRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $helperChecker;
    protected $storageHelper;

    public function __construct()
    {
        $this->obj = new CategoryFood();
        $this->helperChecker = new HelperChecker();
        $this->storageHelper = new StorageHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function list($parameters, $export = false)
    {
        $page = $parameters->has('page') ? $parameters->get('page') : 1;
        $limit = $parameters->has('limit') ? $parameters->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $query = $model
            ->selectRaw("restaurant_categoryfoods.*")
            ->where('restaurant_categoryfoods.deleted_at', null);

        if ($parameters != null) {
            if (isset($parameters['search'])) {
                if($parameters['search'] != 'null'){
                    $text_search = $parameters->get('search');
                    if ($text_search === 'null') {
                        $text_search = null;
                    }
                    if ($text_search !== null) {
                        $text_search = strtoupper($text_search);

                        $query = $query->where(function ($sql) use($text_search) {
                            $sql->where('restaurant_categoryfoods.description', 'like', '%' . $text_search . '%');
                        });
                    }
                }
            }
        }

        $all_data = $query->get();

        if ($export) {
            $query = $query->orderBy('restaurant_categoryfoods.id', 'DESC')->get();
        } else {
            $query = $query->skip(($page - 1) * $limit)->take($limit)->orderBy('restaurant_categoryfoods.id', 'DESC')->get()->toArray();
        }

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $this->helperChecker->checkSeemDescriptionModel($this->model(), 'description', $attributes['description'], 'Categoría plato');
        $item = new CategoryFood();
        $item->description = $attributes['description'];
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;

    }

    public function saveUrlImage($item, $attributes)
    {
        $image = $attributes['url_image'];
        if ($image != null) {
            $file_url = $this->storageHelper->saveUrlImgCategoryFood($attributes);
            $item->url_image = $file_url;
            $item->save();
        }
    }

    public function updated($id, array $attributes)
    {
        $this->helperChecker->checkUpdateSeemDescriptionModel($id, $this->model(), 'description', $attributes['description'], 'Categoría plato');

        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->url_image = null;
        $item->save();

        $this->saveUrlImage($item, $attributes);
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->where('id', $id)->where('deleted_at', null)->first();
        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        $text_search = strtoupper($text);
        return $this->obj
            ->where('deleted_at', null)
            ->where('description', 'LIKE', '%' . $text_search . '%')
            ->get();
    }
}