<?php

namespace App\Models\Tenant\Sale\Client;

use App\Core\ModelsCore;
use App\Helper\StorageHelper;
use App\Models\Tenant\Config\TypeDocument\TypeDocument;
use App\Models\Tenant\Config\TypeDocument\TypeDocumentRepository;
use App\Models\Tenant\Sale\Sale\Sale;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Client extends ModelsCore
{
    use UsesTenantConnection;

    protected $storageHelper;

    protected $table = 'sale_clients';

    protected $appends = ["urlImageBase", "typeDocument", "typeDocumentCode"];

    public function __construct()
    {
        $this->storageHelper = new StorageHelper();
    }


    // public function sales(){
    //     return $this->hasMany(Sale::class,'client_id', 'id');
    // }


    public function geturlImageBaseAttribute()
    {
        if (isset($this->attributes['url_image'])) {
            $url_image = $this->attributes['url_image'];
            if ($url_image != null or $url_image != '') {
                $url_image = $this->storageHelper->getUrlImgClient($url_image);
            }
            return $url_image;
        }
    }

    public function gettypeDocumentCodeAttribute()
    {
        if (isset($this->attributes['typedocument_id'])) {
            $type = new TypeDocumentRepository();
            $data_type = $type->find($this->attributes['typedocument_id']);
            return $data_type['sunat_id'];
        }
    }

    public function gettypeDocumentAttribute()
    {
        if (isset($this->attributes['typedocument_id'])) {
            $type = new TypeDocumentRepository();
            $data_type = $type->find($this->attributes['typedocument_id']);
            return $data_type['description'];
        }
    }


}
