<?php

namespace App\Models\Tenant\Sale\Order;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Order extends ModelsCore
{

    use UsesTenantConnection;

    protected $table = 'sale_orders';


    protected $appends = ["classDelivered", "messageDelivered"];


    public function getclassDeliveredAttribute()
    {
        $class = "warning";
        if (isset($this->attributes['is_delivered'])) {
            $class = "success";
        }
        return $class;
    }


    public function getmessageDeliveredAttribute()
    {
        $class = "Pendiente";
        if (isset($this->attributes['is_delivered'])) {
            $class = "Entregado";
        }
        return $class;
    }




}
