<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 26/05/2020
 * Time: 11:40 PM
 */

namespace App\Models\Tenant\Sale\Order;
use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class OrderRepository implements BaseRepositoryInterface
{

    protected $utilHelper;
    protected $obj;

    public function __construct()
    {
        $this->obj = new Order();
        $this->utilHelper = new UtilHelper();
    }


    public function dbTable()
    {
        return DB::table($this->obj->getTable());
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $get_correlative = $this->utilHelper->createOrderCorrelative();
        $item = new Order();
        $item->user_id = auth()->user()->id;
        $item->client_id = $attributes['client_id'];
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->nro_voucher = $attributes['nro_voucher'];
        $item->code = $get_correlative['code'];
        $item->correlative = $get_correlative['correlative'];
        $item->date_order = $attributes['date_order'];
        $item->shift = $attributes['shift'];
        $item->observation = $attributes['observation'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->text_amount = $attributes['text_amount'];
        $item->save();
        return $item;
    }


    public function listOrder($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $statusDelivered = $header->has('statusDelivered') ? $this->utilHelper->strToBooleanValue($header->get('statusDelivered')) : false;
        $model = $this->model();

        $user = auth()->user();

        $data = $model
            ->join('users', 'sale_orders.user_id', '=', 'users.id')
            ->join('sale_clients', 'sale_orders.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->leftjoin('sale_sales', 'sale_orders.sale_id', '=', 'sale_sales.id')
            ->select('sale_orders.*', 'sale_clients.fullname as client_fullname',
                'sale_clients.document as client_document', 'sale_clients.address as client_address', 'config_typedocument.description as typedocument',
                'sale_sales.code as sale_code',
                'sale_sales.id as sale_id')
            ->where('sale_orders.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_orders.deleted_at', null)
            ->where('sale_orders.is_delivered', $statusDelivered);


        // list orders by profile user
        if($user->profile_id == config('app.profile_seller')){
            $data = $data->where('sale_orders.user_id',$user->id);
        }
        // ============================


        $all_data = $data->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data->where('sale_orders.code', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_orders.observation', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('sale_orders.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function listCommand($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $user = auth()->user();

        $data = $model
            ->join('users', 'sale_orders.user_id', '=', 'users.id')
            ->leftjoin('sale_clients', 'sale_orders.client_id', '=', 'sale_clients.id')
            ->leftjoin('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->leftjoin('sale_sales', 'sale_orders.sale_id', '=', 'sale_sales.id')
            ->select('sale_orders.*', 'sale_clients.fullname as client_fullname',
                'sale_clients.document as client_document', 'sale_clients.address as client_address', 'config_typedocument.description as typedocument',
                'sale_sales.code as sale_code',
                'sale_sales.id as sale_id')
            ->where('sale_orders.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_orders.deleted_at', null);

        $all_data = $data->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }

            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data->where('sale_orders.code', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_orders.observation', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
            else{
                $data = $data->where(DB::raw('DATE(sale_orders.date_order)'), "=", $header['start_range']);
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('sale_orders.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function createCommand(array $attributes)
    {
        $get_correlative = $this->utilHelper->createOrderCorrelative();

        $item = new Order();
        $item->user_id = auth()->user()->id;
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->code = $get_correlative['code'];
        $item->correlative = $get_correlative['correlative'];
        $item->date_order = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->number_table = $attributes['number_table'];
        $item->observation = $attributes['observation'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->text_amount = $attributes['text_amount'];
        $item->is_delivered = $attributes['is_delivered'];

        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo reference
        if (isset($attributes['reference'])){
            $check_column = \Schema::connection("tenant")->hasColumn('sale_orders','reference');
            if($check_column)
                $item->reference = $attributes['reference'];
        }

        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->client_id = $attributes['client_id'];
        $item->date_order = $attributes['date_order'];
        $item->shift = $attributes['shift'];
        $item->observation = $attributes['observation'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->text_amount = $attributes['text_amount'];
        $item->save();
        return $item;
    }


    public function updatedCommand($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->number_table = $attributes['number_table'];
        $item->observation = $attributes['observation'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->text_amount = $attributes['text_amount'];
        $item->is_delivered = $attributes['is_delivered'];
        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo reference
        if (isset($attributes['reference'])){
            $check_column = \Schema::connection("tenant")->hasColumn('sale_orders','reference');
            if($check_column)
                $item->reference = $attributes['reference'];
        }
        $item->save();
        return $item;
    }

    public function closeCommand($id)
    {
        $item = $this->obj->find($id);
        $item->status_command = true;
        $item->save();
        return $item;
    }

    public function updatedDelivered($id)
    {
        $item = $this->obj->find($id);
        $item->is_delivered = true;
        $item->save();
        return $item;
    }

    public function findJoined($id)
    {
        $item = $this->obj
            ->leftjoin('sale_clients', 'sale_orders.client_id', '=', 'sale_clients.id')
            ->leftjoin('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->selectRaw("
                sale_orders.*,
                sale_clients.fullname as client_fullname,
                sale_clients.document as client_document,
                sale_clients.address as client_address,
                config_typedocument.description as typedocument
            ")
            ->where('sale_orders.deleted_at', null)
            ->where('sale_orders.id', $id)
            ->first();

        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }


    public function getOrderLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('deleted_at', null)
            ->orderBy('id', 'desc')
            ->first();

        return $item;
    }


    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
