<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 26/05/2020
 * Time: 11:41 PM
 */

namespace App\Models\Tenant\Sale\OrderDetail;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class OrderDetailRepository implements BaseRepositoryInterface
{

    protected $obj;

    public function __construct()
    {
        $this->obj = new OrderDetail();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new OrderDetail();
        $item->order_id = $attributes['order_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->equivalence = $attributes['equivalence'];
        $item->detail = $attributes['detail'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->equivalence = $attributes['equivalence'];
        $item->detail = $attributes['detail'];
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function findByOrderId($order_id){
        $query = $this->obj
            ->where('sale_detailorders.deleted_at', null)
            ->where('sale_detailorders.order_id', $order_id)
            ->get();

        return $query;
    }

    public function findByOrderIdAndProductId($order_id, $product_id){
        $query = $this->obj
            ->where('sale_detailorders.product_id', $product_id)
            ->where('sale_detailorders.order_id', $order_id)
            ->first();

        return $query;
    }

    public function findByOrderIdAndProductIdAndVariantId($order_id, $product_id, $variant_id){
        $query = $this->obj
            ->where('sale_detailorders.order_id', $order_id)
            ->where('sale_detailorders.product_id', $product_id)
            ->where('sale_detailorders.productvariant_id', $variant_id)
            ->first();

        return $query;
    }

    public function findByOrderIdAndProductIdAndEquivalenceId($order_id, $product_id, $equivalence_id){
        $query = $this->obj
            ->where('sale_detailorders.order_id', $order_id)
            ->where('sale_detailorders.product_id', $product_id)
            ->where('sale_detailorders.productequivalence_id', $equivalence_id)
            ->first();

        return $query;
    }

    public function findByOrderIdJoined($order_id)
    {
        return $this->obj
            ->join('catalog_products', 'sale_detailorders.product_id', '=', 'catalog_products.id')
            ->join('config_unitsofmeasure', 'sale_detailorders.unitmeasure_id', '=', 'config_unitsofmeasure.id')
            ->select('sale_detailorders.*',
                'catalog_products.description as description',
                'catalog_products.typeprice_id as typeprice_id',
                'config_unitsofmeasure.description as unitmeasure',
                'sale_detailorders.productvariant_id as productvariant_id',
                'sale_detailorders.productequivalence_id as productequivalence_id',
                'sale_detailorders.id as detail_id',
                'sale_detailorders.product_id as id',
                DB::raw('(sale_detailorders.quantity * sale_detailorders.price) as subtotal, 
                (sale_detailorders.quantity * sale_detailorders.price + sale_detailorders.igv) as total'))
            ->where('sale_detailorders.deleted_at', null)
            ->where('sale_detailorders.order_id', $order_id)
            ->get();
    }


    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }


    public function reportByDateGroupByProduct($date, $shift)
    {

        $query = $this->obj
            ->join('sale_orders', 'sale_detailorders.order_id', '=', 'sale_orders.id')
            ->join('catalog_products', 'sale_detailorders.product_id', '=', 'catalog_products.id')
//            ->select('catalog_products.id as product_id', 'catalog_products.description as description', DB::raw('SUM(sale_detailorders.quantity) as quantity'))
            ->selectRaw("catalog_products.id as product_id, catalog_products.description as description, SUM(sale_detailorders.quantity) as quantity")
            ->where('sale_orders.date_order',''.$date.'')
            ->where('sale_orders.shift', $shift)
            ->where('sale_orders.is_delivered', false)
            ->groupBy('catalog_products.id', 'catalog_products.description')
            ->get();


//        $query = \DB::select('SELECT
//                                catalog_products.id as product_id,
//                                catalog_products.description as description,
//                                sum(sale_detailorders.quantity) as quantity
//                            FROM
//                                sale_detailorders
//                            INNER JOIN sale_orders ON sale_detailorders.order_id = sale_orders.id
//                            INNER JOIN catalog_products ON sale_detailorders.product_id = catalog_products.id
//                            WHERE
//                                sale_orders.date_order = \''.$date.'\'
//                            AND sale_orders.shift = \''.$shift.'\'
//                            AND sale_orders.is_delivered = FALSE
//                            GROUP BY catalog_products.id ');

        return $query;

    }

    public function reportByProductByUser($product_id, $user_id, $shift)
    {

        $query = $this->obj
            ->join('sale_orders', 'sale_detailorders.order_id', '=', 'sale_orders.id')
            ->selectRaw("SUM(sale_detailorders.quantity) AS quantity")
            ->where('sale_detailorders.product_id', $product_id)
            ->where('sale_orders.user_id', $user_id)
            ->where('sale_orders.shift', $shift)
            ->where('sale_orders.is_delivered', false)
            ->get();

//        $query = \DB::select('SELECT
//                                SUM (sale_detailorders.quantity) AS quantity
//                            FROM
//                                sale_detailorders
//                            INNER JOIN sale_orders ON sale_detailorders.order_id = sale_orders. ID
//                            WHERE
//                                sale_detailorders.product_id = '.$product_id.'
//                            AND sale_orders.user_id = '.$user_id.'
//                            AND sale_orders.shift = \''.$shift.'\'
//                            AND sale_orders.is_delivered = FALSE ' );
        return $query;

    }
}