<?php

namespace App\Models\Tenant\Sale\Proforma;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Proforma extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'sale_proformas';

    protected $appends = ["status"];

    public function getstatusAttribute()
    {
        if (isset($this->attributes['date_expiration'])) {
           $date_now = date('Y-m-d');
           $response = array();
           if ($date_now <= $this->attributes['date_expiration']){
               $response['msg'] = 'Disponible';
               $response['class'] = 'success';
           }
           else{
               $response['msg'] = 'Caducado';
               $response['class'] = 'danger';
           }
           return $response;
        }
    }
}
