<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 24/09/2020
 * Time: 11:00 PM
 */

namespace App\Models\Tenant\Sale\Proforma;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class ProformaRepository implements BaseRepositoryInterface
{
    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Proforma();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listProforma($header){
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $data = $model
            ->join('sale_clients', 'sale_proformas.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->select('sale_proformas.*', 'sale_clients.fullname as client_fullname',
                'sale_clients.document as client_document', 'config_typedocument.description as typedocument')
            ->where('sale_proformas.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_proformas.deleted_at', null);

        $all_data = $model->all();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if($text_search === 'null'){
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('sale_proformas.nro_voucher', 'LIKE', '%'. $text_search.'%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
            else{
                $data = $data->whereBetween('sale_proformas.date_issue', [$header['start_range'], $header['end_range']]);
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('sale_proformas.id', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $attributes['typevoucher_id'] = config('app.voucher_proforma_id');
        $branchoffice_id = $this->utilHelper->getBranchOffice();
        $get_correlative = $this->utilHelper->getCorrelativeVoucher($attributes['typevoucher_id'], null, $branchoffice_id);

        $item = new Proforma();
        $item->user_id = auth()->user()->id;
        $item->client_id = $attributes['client_id'];
        $item->branchoffice_id = $branchoffice_id;
        $item->voucher_id = $attributes['typevoucher_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->serie = $get_correlative['serie']; // get serie
        $item->nro_voucher = $get_correlative['nro_voucher']; // nro voucher
        $item->correlative = $get_correlative['correlative']; // get correlative
        $item->date_issue = $attributes['date_issue'];
        $item->date_expiration = $attributes['date_expiration'];
        $item->observation = $attributes['observation'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->url_file = null;
        $item->email = $attributes['email'];
        $item->address = $attributes['address'];
        $item->cellphone = $attributes['cellphone'];
        $item->text_amount = $attributes['text_amount'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->client_id = $attributes['client_id'];
        $item->accountbank_id = $attributes['accountbank_id'];
        $item->date_issue = $attributes['date_issue'];
        $item->date_expiration = $attributes['date_expiration'];
        $item->observation = $attributes['observation'];
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->url_file = null;
        $item->email = $attributes['email'];
        $item->address = $attributes['address'];
        $item->cellphone = $attributes['cellphone'];
        $item->text_amount = $attributes['text_amount'];
        $item->save();

        return $item;
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function findJoined($id)
    {
        $item = $this->obj
            ->join('sale_clients', 'sale_proformas.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->leftjoin('finance_accountbanks','sale_proformas.accountbank_id','=','finance_accountbanks.id')
            ->leftjoin('finance_banks', 'finance_accountbanks.bank_id', '=', 'finance_banks.id')
            ->selectRaw("
                sale_proformas.*,
                CASE
                    WHEN sale_proformas.accountbank_id NOTNULL THEN concat(finance_banks.description, ' - ', finance_accountbanks.name)
                    ELSE '-'
                END as accountbank, 
                sale_clients.fullname as client_fullname, 
                sale_clients.document as client_document,
                config_typedocument.description as typedocument
            ")
            ->where('sale_proformas.deleted_at', null)
            ->where('sale_proformas.id', $id)
            ->first();

        return $item;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {

    }
}