<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 24/09/2020
 * Time: 11:01 PM
 */

namespace App\Models\Tenant\Sale\ProformaDetail;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class ProformaDetailRepository implements BaseRepositoryInterface
{
    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new ProformaDetail();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ProformaDetail();
        $item->proforma_id = $attributes['proforma_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->equivalence = $attributes['equivalence'];
        $item->detail = $attributes['detail'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->equivalence = $attributes['equivalence'];
        $item->detail = $attributes['detail'];
        $item->deleted_at = null;
        $item->save();
        return $item;
    }

    public function findByProformaIdJoined($proforma_id)
    {
        return $this->obj
            ->join('catalog_products', 'sale_detailproformas.product_id', '=', 'catalog_products.id')
            ->join('config_unitsofmeasure', 'sale_detailproformas.unitmeasure_id', '=', 'config_unitsofmeasure.id')
            ->select('sale_detailproformas.*',
                'catalog_products.description as description',
                'config_unitsofmeasure.description as unitmeasure',
                'sale_detailproformas.id as detail_id',
                'sale_detailproformas.product_id as id',
                DB::raw('(sale_detailproformas.quantity * sale_detailproformas.price) as subtotal, 
                (sale_detailproformas.quantity * sale_detailproformas.price + sale_detailproformas.igv) as total'))
            ->where('sale_detailproformas.deleted_at', null)
            ->where('sale_detailproformas.proforma_id', $proforma_id)
            ->get();
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function findByProformaId($proforma_id){
        $query = $this->obj
            ->where('sale_detailproformas.deleted_at', null)
            ->where('sale_detailproformas.proforma_id', $proforma_id)
            ->get();

        return $query;
    }

    public function findByProformaIdAndProductId($proforma_id, $product_id){
        $query = $this->obj
            ->where('sale_detailproformas.product_id', $product_id)
            ->where('sale_detailproformas.proforma_id', $proforma_id)
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}