<?php

namespace App\Models\Tenant\Sale\Sale;

use App\Core\ModelsCore;
use App\Models\Tenant\Company\Employee\EmployeeRepository;
use App\Models\Tenant\Config\TypeTransaction\TypeTransactionRepository;
use App\Models\Tenant\Sale\Client\Client;
use App\Models\Tenant\Sale\Client\ClientRepository;
use App\Models\Tenant\Sale\SaleDetail\SaleDetailRepository;
use App\Models\Tenant\Sale\SalePaid\SalePaidRepository;
use App\Models\Tenant\Sale\ScheduleSale\ScheduleSaleRepository;
use App\Models\Tenant\Sale\ScheduleSaleDetail\ScheduleSaleDetailRepository;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Sale extends ModelsCore
{
    use UsesTenantConnection;

    protected $rTypeTransaction;
    protected $rSalePaid;
    protected $rScheduleSale;
    protected $rScheduleSaleDetail;

    public function __construct()
    {
        $this->rTypeTransaction = new TypeTransactionRepository();
        $this->rSalePaid = new SalePaidRepository();
        $this->rScheduleSale = new ScheduleSaleRepository();
        $this->rScheduleSaleDetail = new ScheduleSaleDetailRepository();

    }

    protected $table = 'sale_sales';

    protected $appends = ["client_data", "status_paid", "typetransaction", "nextschedule", "employee_data", "detail_data"];


    // public function clientData()
    // {
    //     return $this->belongsTo(Client::class, 'client_id', 'id');
    // }


    public function getclientDataAttribute()
    {
        if (isset($this->attributes['client_id'])) {
            $client= new ClientRepository();
            $data = $client->find($this->attributes['client_id']);
            return $data;
        }
    }

    public function getemployeeDataAttribute()
    {
        if (isset($this->attributes['employe_id'])) {
            $item= new EmployeeRepository();
            $data = $item->find($this->attributes['employe_id']);
            return $data;
        }
    }

    public function getstatusPaidAttribute(){
        $item = $this->rSalePaid->findBySale($this->attributes['id']);
        $response = array(
            'class'=>'primary',
            'message'=>'Concretado',
        );
        if($item['total_amount'] != $item['total_paid']){
            $response = array(
                'class'=>'warning',
                'message'=>'Pendiente',
            );
        }

        return $response;
    }


    public function gettypetransactionAttribute()
    {
        if (isset($this->attributes['typetransaction_id'])) {
            $description = $this->rTypeTransaction->find($this->attributes['typetransaction_id']);
            return $description['description'];
        }
    }

    public function getnextscheduleAttribute(){
        if (isset($this->attributes['typetransaction_id'])) {
            $response = null;
            if($this->attributes['typetransaction_id'] == config('app.transaction_credit')){
                $sale_paid = $this->rSalePaid->findBySale($this->attributes['id']);
                if($sale_paid->total_amount != $sale_paid->total_paid){
                    $schedule = $this->rScheduleSale->findBySale($this->attributes['id']);
                    $response = $this->rScheduleSaleDetail->findNextBySchedule($schedule['id']);
                }
            }

            return $response;
        }
    }

    public function getdetailDataAttribute()
    {
        if (isset($this->attributes['bookinghotel_id'])) {
            $rSaleDetail = new SaleDetailRepository();
            $sale_detail = $rSaleDetail->findBySaleJoined($this->attributes['id']);;
            return $sale_detail;
        }
    }

}
