<?php

/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 20/07/2020
 * Time: 01:15 PM
 */

namespace App\Models\Tenant\Sale\Sale;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class SaleRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new Sale();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function listSale($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $data = $model
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            // ->select('sale_sales.*', 'sale_clients.fullname as client',
            //         'sale_clients.document as client_document', 'config_typedocument.description as typedocument')

            ->selectRaw("
                sale_sales.*, 
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                config_typedocument.description as typedocument
                ")

            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice());
        //            ->where('sale_sales.deleted_at', null);

        $all_data = $model->count();
        // $all_data = $model->all();

        if ($header != null) {

            if ($header->has('search')) {
                $text_search = $header->get('search');                
                if ($text_search === 'null') {
                    $text_search = null;
                }
                if ($text_search !== null) {
                    $text_search = strtoupper($text_search);
                    $data = $data
                        ->where('code', 'LIKE', '%' . $text_search . '%')
                        ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                        ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                    // $all_data = $data->get();
                    
                }
                // else{
                //     $data = $data->whereBetween(DB::raw('DATE(sale_sales.date_sale)'), [$header['start_range'], $header['end_range']]);
                // }
            }

            if (isset($header['start_range'])) {
                $data = $data->whereBetween(DB::raw('DATE(sale_sales.date_sale)'), [$header['start_range'], $header['end_range']]);
            }

            $all_data = $data->count();
        }



       

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('sale_sales.date_sale', 'DESC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => $all_data,
            // 'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function listCharge($header)
    {
        $page = $header->has('page') ? $header->get('page') : 1;
        $limit = $header->has('limit') ? $header->get('limit') : config('app.paginate_by');
        $model = $this->model();

        $data = $model
            ->join('sale_paid', 'sale_sales.id', '=', 'sale_paid.sale_id')
            ->join('sale_schedule', 'sale_sales.id', '=', 'sale_schedule.sale_id')
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->selectRaw("sale_sales.*,
                sale_paid.*,
                sale_sales.id as id,
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                config_typedocument.description as typedocument,
                (SELECT sale_detailschedule.date_assigned FROM sale_detailschedule
                WHERE sale_detailschedule.schedule_id = sale_schedule.id
                AND sale_detailschedule.is_paid = false
                ORDER BY sale_detailschedule.date_assigned ASC LIMIT 1) as nextdateschedule")
            ->whereRaw('sale_paid.total_amount != sale_paid.total_paid')
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_sales.deleted_at', null);

        $all_data = $model
            ->join('sale_paid', 'sale_sales.id', '=', 'sale_paid.sale_id')
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->select(
                'sale_sales.*',
                'sale_paid.*',
                'sale_sales.id as id',
                'sale_clients.fullname as client',
                'sale_clients.document as client_document',
                'config_typedocument.description as typedocument'
            )
            ->whereRaw('sale_paid.total_amount != sale_paid.total_paid')
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_sales.deleted_at', null)
            ->get();

        if ($header->has('search')) {
            $text_search = $header->get('search');
            if ($text_search === 'null') {
                $text_search = null;
            }
            if ($text_search !== null) {
                $text_search = strtoupper($text_search);
                $data = $data
                    ->where('code', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.fullname', 'LIKE', '%' . $text_search . '%')
                    ->orwhere('sale_clients.document', 'LIKE', '%' . $text_search . '%');
                $all_data = $data->get();
            }
        }

        $query = $data->skip(($page - 1) * $limit)->take($limit)->orderBy('nextdateschedule', 'ASC')->get()->toArray();

        $response = array(
            'results' => $query,
            'count' => count($query),
            'total' => count($all_data),
            'paginate_by' => config('app.paginate_by')
        );

        return $response;
    }

    public function create(array $attributes)
    {
        $get_correlative = $this->utilHelper->createSaleCorrelative();

        $item = new Sale();
        $item->user_id = auth()->user()->id;
        $item->client_id = $attributes['client_id'];
        $item->branchoffice_id = $this->utilHelper->getBranchOffice();
        $item->typetransaction_id = $attributes['typetransaction_id'];
        $item->code = $get_correlative['code'];
        $item->correlative = $get_correlative['correlative'];
        $item->date_sale = $this->utilHelper->transformDatetime(date('Y-m-d'));
        $item->is_igv = $attributes['is_igv'];
        $item->igv = $attributes['igv'];
        $item->subtotal = $attributes['subtotal'];
        $item->total = $attributes['total'];
        $item->is_grouped = $attributes['is_grouped'];
        $item->description_grouped = $attributes['description_grouped'];

        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo observation (se coloco para ngautomotri nro placa)

        if (isset($attributes['observation'])) {
            $check_column = \Schema::connection("tenant")->hasColumn('sale_sales', 'observation');
            if ($check_column)
                $item->observation = $attributes['observation'];
        }

        if (isset($attributes['employe_id'])) {
            $item->employe_id = $attributes['employe_id'];
        }

        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo origin_id y channel_id (se coloco para nativa)
        if (isset($attributes['origin_id'])) {
            $check_column = \Schema::connection("tenant")->hasColumn('sale_sales', 'origin_id');
            if ($check_column) {
                $item->origin_id = $attributes['origin_id'];
            }
        }

        if (isset($attributes['channel_id'])) {
            $check_column = \Schema::connection("tenant")->hasColumn('sale_sales', 'channel_id');
            if ($check_column) {
                $item->channel_id = $this->utilHelper->checkCeroToNull($attributes['channel_id']);
            }
        }

        // BOOK HOTEL
        if (isset($attributes['bookinghotel_id'])) {
            $check_column = \Schema::connection("tenant")->hasColumn('sale_sales', 'bookinghotel_id');
            if ($check_column)
                $item->bookinghotel_id = $attributes['bookinghotel_id'];
        }

        $item->save();
        return $item;
    }

    public function getSaleLastCheckCorrelative()
    {
        $item = $this->obj
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->orderBy('id', 'desc')
            ->first();

        return $item;
    }

    public function updated($id, array $attributes)
    {
    }

    public function findJoinedRemake($id)
    {
        $item = $this->obj
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->selectRaw("
                sale_sales.*,
                sale_clients.fullname as client_fullname,
                sale_clients.document as client_document,
                sale_clients.address as client_address,
                config_typedocument.description as typedocument
            ")
            ->where('sale_sales.id', $id)
            ->first();

        return $item;
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findByBookingHotelId($bookinghotel_id)
    {
        return $this->obj->where("bookinghotel_id", $bookinghotel_id)->get();
    }

    public function paymentsAssociateToSale($sale_id)
    {
        $query = $this->obj
            ->join('sale_paid', 'sale_paid.sale_id', '=', 'sale_sales.id')
            ->join('sale_amortizations', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->join('money_movements', 'sale_amortizations.moneymovement_id', '=', 'money_movements.id')
            ->select(
                'money_movements.*',
                'sale_amortizations.total_amount as total_amount'
            )
            ->where('sale_paid.sale_id', $sale_id)
            ->where('money_movements.date_repayment', null)
            ->orderBy('money_movements.date_movement', 'ASC')
            ->get();

        return $query;
    }

    public function findSaleJoinedSalePaid($sale_id)
    {
        $query = $this->obj
            ->join('sale_paid', 'sale_sales.id', '=', 'sale_paid.sale_id')
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->select(
                'sale_sales.*',
                'sale_paid.*',
                'sale_sales.id as id',
                'sale_paid.id as salepaid_id',
                'sale_clients.id as client_id',
                'sale_clients.fullname as client',
                'sale_clients.document as client_document',
                'config_typedocument.description as typedocument'
            )
            ->where('sale_sales.id', $sale_id)
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        $item = $this->obj->find($id);
        $item->delete();
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }

    public function rowExportSales($parameters)
    {
        $data = $this->obj
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('sale_paid', 'sale_sales.id', '=', 'sale_paid.sale_id')
            ->selectRaw("sale_sales.*,
                DATE(sale_sales.date_sale) as date_sale,
                cast(sale_sales.date_sale::timestamp as time) as date_hour,
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                CASE WHEN sale_paid.total_amount != sale_paid.total_paid THEN 'Pendiente' ELSE 'Concretado' END AS status")
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->whereBetween(DB::raw('DATE(sale_sales.date_sale)'), [$parameters['start_range'], $parameters['end_range']]);

        return $data->orderBy('sale_sales.date_sale', 'DESC')->get();
    }

    public function sumTotalSaleByMonth()
    {

        $month = date('m');
        $year = date("Y");

        $query = $this->obj
            ->selectRaw("CASE WHEN SUM(total) ISNULL THEN 0 ELSE SUM(total) END AS total_month")
            ->whereRaw("EXTRACT(MONTH from sale_sales.date_sale) = " . $month)
            ->whereRaw("EXTRACT(YEAR from sale_sales.date_sale) = " . $year)
            ->where('branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where("sale_sales.deleted_at", null)
            ->first();

        return $query;
    }

    public function totalSaleMonthByYear($parameters = null)
    {

        $year = date("Y");

        if ($parameters == null) {
            $query = DB::connection('tenant')
                ->select("SELECT
                CASE
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 1 THEN 'enero'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 2 THEN 'febrero'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 3 THEN 'marzo'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 4 THEN 'abril'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 5 THEN 'mayo'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 6 THEN 'junio'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 7 THEN 'julio'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 8 THEN 'agosto'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 9 THEN 'septiembre'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 10 THEN 'octubre'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 11 THEN 'noviembre'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 12 THEN 'diciembre'
				END as name_month,
				EXTRACT(MONTH from sale_sales.date_sale) as number_month,
				sum(sale_sales.total) as total_month
                FROM
                    sale_sales
                WHERE sale_sales.deleted_at ISNULL
                AND sale_sales.branchoffice_id = " . $this->utilHelper->getBranchOffice() . "
                 AND EXTRACT(YEAR from sale_sales.date_sale) = '" . $year . "'
                GROUP BY EXTRACT(MONTH from sale_sales.date_sale)");
        } else {
            $branchoffice = "";
            $year = "";
            if (isset($parameters['branchoffice'])) {
                if ($parameters['branchoffice'] != 'null')
                    $branchoffice = " AND sale_sales.branchoffice_id = " . $parameters['branchoffice'];
            }

            if (isset($parameters['year'])) {
                if ($parameters['year'] != 'null')
                    $year = " AND EXTRACT(YEAR from sale_sales.date_sale) = '" . $parameters['year'] . "'";
            }


            $query = DB::connection('tenant')
                ->select("SELECT
                CASE
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 1 THEN 'enero'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 2 THEN 'febrero'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 3 THEN 'marzo'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 4 THEN 'abril'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 5 THEN 'mayo'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 6 THEN 'junio'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 7 THEN 'julio'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 8 THEN 'agosto'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 9 THEN 'septiembre'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 10 THEN 'octubre'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 11 THEN 'noviembre'
                    WHEN EXTRACT(MONTH from sale_sales.date_sale) = 12 THEN 'diciembre'
				END as name_month,
				EXTRACT(MONTH from sale_sales.date_sale) as number_month,
				sum(sale_sales.total) as total_month
                FROM
                    sale_sales
                WHERE sale_sales.deleted_at ISNULL
                " . $branchoffice . $year . "
                GROUP BY EXTRACT(MONTH from sale_sales.date_sale)");
        }


        return $query;
    }

    public function historyClientVip($parameters = null)
    {
        $query = array();

        if ($parameters != null) {
            $branchoffice = "";
            $range_date = "";
            $limit = 5;
            if (isset($parameters['branchoffice'])) {
                if ($parameters['branchoffice'] != 'null')
                    $branchoffice = " AND sale_sales.branchoffice_id = " . $parameters['branchoffice'];
            }

            if (isset($parameters['start_range'])) {
                if ($parameters['start_range'] != 'null')
                    $range_date = " AND DATE(sale_sales.date_sale) BETWEEN '" . $parameters['start_range'] . "' AND '" . $parameters['end_range'] . "'";
            }

            if (isset($parameters['limit'])) {
                if ($parameters['limit'] != 'null')
                    $limit = $parameters['limit'];
            }

            $query = DB::connection('tenant')
                ->select("SELECT
                            sale_clients.id,
                            sale_clients.fullname as client_fullname,
                            sale_clients.document as client_document,
                            config_typedocument.description as typedocument,
                            SUM(sale_sales.total) as total_sale,
                            COUNT(sale_sales.id) as quantity_sale
                        FROM
                            sale_sales
                        INNER JOIN sale_clients ON sale_sales.client_id = sale_clients.id
                        INNER JOIN config_typedocument ON sale_clients.typedocument_id = config_typedocument.id
                        WHERE sale_sales.deleted_at ISNULL
                        " . $branchoffice . $range_date . "
                        GROUP BY sale_clients.id, config_typedocument.description
                        ORDER BY total_sale DESC
                        LIMIT " . $limit);
        }

        return $query;
    }

    public function historyEmployeeSale($parameters = null)
    {
        $query = array();

        if ($parameters != null) {
            $branchoffice = "";
            $range_date = "";

            if (isset($parameters['branchoffice'])) {
                if ($parameters['branchoffice'] != 'null')
                    $branchoffice = " AND sale_sales.branchoffice_id = " . $parameters['branchoffice'];
            }

            if (isset($parameters['start_range'])) {
                if ($parameters['start_range'] != 'null')
                    $range_date = " AND DATE(sale_sales.date_sale) BETWEEN '" . $parameters['start_range'] . "' AND '" . $parameters['end_range'] . "'";
            }

            $query = DB::connection('tenant')
                ->select("SELECT
                            company_employees.id,
                            company_employees.fullname AS employee_fullname,
                            company_employees.document AS employee_document,
                            company_jobs.description AS employee_job,
                            SUM (sale_sales.total) AS total_sale,
                            COUNT(sale_sales.id) AS quantity_sale
                        FROM
                            sale_sales
                        INNER JOIN company_employees ON sale_sales.employe_id = company_employees.id
                        INNER JOIN company_jobs ON company_employees.companyjob_id = company_jobs.id
                        WHERE sale_sales.deleted_at ISNULL
                        " . $branchoffice . $range_date . "
                        GROUP BY company_employees.id, company_jobs.description
                        ORDER BY total_sale DESC ");
        }

        return $query;
    }

    public function top10listCharge()
    {
        $model = $this->model();

        $data = $model
            ->join('sale_paid', 'sale_sales.id', '=', 'sale_paid.sale_id')
            ->join('sale_schedule', 'sale_sales.id', '=', 'sale_schedule.sale_id')
            ->join('sale_clients', 'sale_sales.client_id', '=', 'sale_clients.id')
            ->join('config_typedocument', 'sale_clients.typedocument_id', '=', 'config_typedocument.id')
            ->selectRaw("sale_sales.*,
                sale_paid.*,
                sale_sales.id as id,
                sale_clients.fullname as client,
                sale_clients.document as client_document,
                config_typedocument.description as typedocument,
                (SELECT sale_detailschedule.date_assigned FROM sale_detailschedule
                WHERE sale_detailschedule.schedule_id = sale_schedule.id
                AND sale_detailschedule.is_paid = false
                ORDER BY sale_detailschedule.date_assigned ASC LIMIT 1) as nextdateschedule")
            ->whereRaw('sale_paid.total_amount != sale_paid.total_paid')
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->where('sale_sales.deleted_at', null)
            ->take(10)
            ->orderBy('nextdateschedule', 'ASC')
            ->get()
            ->toArray();

        return $data;
    }
}
