<?php

namespace App\Models\Tenant\Sale\SaleDelivery;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class SaleDeliveryRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new SaleDelivery();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new SaleDelivery();
        $item->description = $attributes['description'];
        $item->cellphone = $attributes['cellphone'];
        $item->address = $attributes['address'];
        $item->email = $attributes['email'];
        $item->delivery_date = $attributes['delivery_date'];
        $item->delivery_time = $attributes['delivery_time'];
        $item->observation = $attributes['observation'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        $item = $this->obj->find($id);
        $item->description = $attributes['description'];
        $item->cellphone = $attributes['cellphone'];
        $item->address = $attributes['address'];
        $item->email = $attributes['email'];
        $item->delivery_date = $attributes['delivery_date'];
        $item->delivery_time = $attributes['delivery_time'];
        $item->observation = $attributes['observation'];
        $item->save();
    }

    public function find($id)
    {
        $item = $this->obj->find($id);
        return $item;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}
