<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 20/07/2020
 * Time: 01:20 PM
 */

namespace App\Models\Tenant\Sale\SaleDetail;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;
use Illuminate\Support\Facades\DB;

class SaleDetailRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new SaleDetail();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new SaleDetail();
        $item->sale_id = $attributes['sale_id'];
        $item->warehouse_id = $attributes['warehouse_id'];
        $item->product_id = $attributes['product_id'];
        $item->unitmeasure_id = $attributes['unit_id'];
        $item->quantity = $attributes['quantity'];
        $item->price = $attributes['price'];
        $item->igv = $attributes['igv'];
        $item->price_general = $attributes['price_sale'];

        //TODO: quitar cuando todas las bases de datos tenga la migracion del campo is_igv (se coloco para empresa nativa)

        if (isset($attributes['is_igv'])){
            $check_column = \Schema::connection("tenant")->hasColumn('sale_detailsales','is_igv');
            if($check_column)
                $item->is_igv = $attributes['is_igv'];
        }

        $item->save();
        return $item;

    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
     return $this->obj->find($id);
    }

    // public function findBySale($sale_id)
    // {
    //     $query = $this->obj->selectRaw("bookinghotel_id, *")->where('sale_id', $sale_id)->get();
    //     return $query;
    // }

    public function findBySale($sale_id)
    {
        $query = $this->obj->selectRaw("*")->where('sale_id', $sale_id)->get();
        return $query;
    }

    public function findBySaleJoined($sale_id)
    {
        return $this->obj
            ->join('catalog_products', 'sale_detailsales.product_id', '=', 'catalog_products.id')
            ->join('config_unitsofmeasure', 'sale_detailsales.unitmeasure_id', '=', 'config_unitsofmeasure.id')
            ->select('sale_detailsales.*',
                'catalog_products.code as code',
                'catalog_products.description as description',
                'config_unitsofmeasure.description as unitmeasure',
                'sale_detailsales.id as detail_id',
                DB::raw("CASE
                            WHEN sale_detailsales.igv ISNULL THEN (sale_detailsales.quantity * sale_detailsales.price)
                            ELSE (sale_detailsales.quantity * sale_detailsales.price) + sale_detailsales.igv
                            END AS subtotal"),
                'sale_detailsales.product_id as id'
//                DB::raw('(sale_detailsales.quantity * sale_detailsales.price) as subtotal')
            )
            ->where('sale_detailsales.deleted_at', null)
            ->where('sale_detailsales.sale_id', $sale_id)
            ->get();
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}