<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 20/07/2020
 * Time: 01:22 PM
 */

namespace App\Models\Tenant\Sale\SalePaid;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class SalePaidRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new SalePaid();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new SalePaid();
        $item->sale_id = $attributes['sale_id'];
        $item->total_amount = $attributes['total_amount'];
        $item->total_paid = $attributes['total_paid'];
        $item->save();
        return $item;
    }

    public function createFromBooking(array $attributes)
    {
        $item = new SalePaid();
        $item->booking_id = $attributes['booking_id'];
        $item->total_amount = $attributes['total_amount'];
        $item->total_paid = $attributes['total_paid'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {

    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findBySale($sale_id)
    {
        return $this->obj->where('sale_id', $sale_id)->first();
    }

    public function findByBooking($booking_id)
    {
        return $this->obj->where('booking_id', $booking_id)->first();
    }

    public function getMovementBySale($sale_id){
        $query = $this->obj
            ->join('sale_amortizations', 'sale_amortizations.salepaid_id', '=', 'sale_paid.id')
            ->join('money_movements', 'sale_amortizations.moneymovement_id', '=', 'money_movements.id')
            ->join('config_typevoucher', 'money_movements.voucher_id', '=', 'config_typevoucher.id')
            ->join('config_paymentmethod', 'money_movements.paymentmethod_id', '=', 'config_paymentmethod.id')
            ->select('money_movements.*',
                'sale_amortizations.total_amount as total_amount',
                'config_typevoucher.description as typevoucher',
                'config_paymentmethod.description as paymethod')
            ->where('sale_paid.sale_id', $sale_id)
            ->where('money_movements.deleted_at', null)
            ->orderBy('money_movements.date_movement', 'ASC')
            ->get();

        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }

    public function sumTotalChargeCredit(){
        $query = $this->obj
            ->join("sale_sales","sale_paid.sale_id","=", "sale_sales.id")
            ->selectRaw("SUM(sale_paid.total_amount - sale_paid.total_paid) as total_credit")
            ->where('sale_sales.branchoffice_id', $this->utilHelper->getBranchOffice())
            ->first();

        return $query;
    }
}
