<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 11/08/2020
 * Time: 02:50 AM
 */

namespace App\Models\Tenant\Sale\ScheduleSale;

use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class ScheduleSaleRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new ScheduleSale();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ScheduleSale();
        $item->sale_id = $attributes['sale_id'];
        $item->date_schedule = date('Y-m-d');
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findBySale($sale_id)
    {
        return $this->obj->where('sale_id', $sale_id)->first();
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}