<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 11/08/2020
 * Time: 02:53 AM
 */

namespace App\Models\Tenant\Sale\ScheduleSaleDetail;


use App\Helper\UtilHelper;
use App\Models\Contract\BaseRepositoryInterface;

class ScheduleSaleDetailRepository implements BaseRepositoryInterface
{

    protected $obj;
    protected $utilHelper;

    public function __construct()
    {
        $this->obj = new ScheduleSaleDetail();
        $this->utilHelper = new UtilHelper();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {
        $item = new ScheduleSaleDetail();
        $item->schedule_id = $attributes['schedule_id'];
        $item->number_quota = $attributes['number_quota'];
//        $item->date_assigned = date('Y-m-d',$attributes['date_assigned']);
        $item->date_assigned = $attributes['date_assigned'];
        $item->amount_assigned = $attributes['amount_assigned'];
        $item->save();
        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        return $this->obj->find($id);
    }

    public function findBySchedule($schedule_id){
        $query = $this->obj
            ->selectRaw("id,
                        saleamortization_id,
                        number_quota,
                        date_assigned,
                        amount_assigned,
                        date_paid,
                        amount_paid,
                        date_part('year', age(date_assigned:: DATE, CURRENT_DATE)) as year_available,
                        date_part('month', age(date_assigned:: DATE, CURRENT_DATE)) as month_available,
                        date_part('day', age(date_assigned:: DATE, CURRENT_DATE)) as day_available,
                        DATE_PART('day', date_assigned:: DATE) - DATE_PART('day', CURRENT_DATE) AS available_days,
                        CASE WHEN (DATE_PART('day', date_assigned :: DATE) - DATE_PART('day', CURRENT_DATE)) < 7 
                        AND (DATE_PART('day', date_assigned :: DATE) - DATE_PART('day', CURRENT_DATE)) >= 4 THEN 'warning'
                        WHEN (DATE_PART('day', date_assigned :: DATE) - DATE_PART('day', CURRENT_DATE)) <= 3 THEN 'danger'
                        ELSE 'primary' END AS bg_available")
            ->where('schedule_id', $schedule_id)
            ->orderBy('date_assigned','ASC')
            ->get();

        return $query;
    }

    public function findNextBySchedule($schedule_id){
        $query = $this->obj
            ->selectRaw("id,
                        saleamortization_id,
                        number_quota,
                        date_assigned,
                        amount_assigned,
                        date_paid,
                        amount_paid,
                        date_part('year', age(date_assigned:: DATE, CURRENT_DATE)) as year_available,
                        date_part('month', age(date_assigned:: DATE, CURRENT_DATE)) as month_available,
                        date_part('day', age(date_assigned:: DATE, CURRENT_DATE)) as day_available,
                        DATE_PART('day', date_assigned:: DATE) - DATE_PART('day', CURRENT_DATE) AS available_days,
                        CASE WHEN (DATE_PART('day', date_assigned :: DATE) - DATE_PART('day', CURRENT_DATE)) < 7 
                        AND (DATE_PART('day', date_assigned :: DATE) - DATE_PART('day', CURRENT_DATE)) >= 4 THEN 'warning'
                        WHEN (DATE_PART('day', date_assigned :: DATE) - DATE_PART('day', CURRENT_DATE)) <= 3 THEN 'danger'
                        ELSE 'primary' END AS bg_available")
            ->where('schedule_id', $schedule_id)
            ->where('is_paid', false)
            ->orderBy('date_assigned','ASC')
            ->first();

        return $query;
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}