<?php

namespace App\Models\Tenant\Ubigeo\Department;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Department extends ModelsCore
{
    use UsesTenantConnection;

    protected $table = 'ubigeo_departments';

    protected $appends = ["code"];

    public function getCodeAttribute()
    {
        return $this->attributes['id'];
    }

    static function idByDescription($description)
    {
        $department = Department::where('name', $description)->first();
        if ($department) {
            return $department->id;
        }
        return '15';
    }
}
