<?php

namespace App\Models\Tenant\Ubigeo\District;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class District extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'ubigeo_districts';

    protected $appends = ["code"];

    public function getCodeAttribute()
    {
        return $this->attributes['id'];
    }

    static function idByDescription($description, $province_id)
    {
        $district = District::where('name', $description)
            ->where('province_id', $province_id)
            ->first();
        if ($district) {
            return $district->id;
        }
        return '150101';
    }
}
