<?php

namespace App\Models\Tenant\Ubigeo\Province;

use App\Core\ModelsCore;
use Hyn\Tenancy\Traits\UsesTenantConnection;
use Illuminate\Database\Eloquent\Model;

class Province extends ModelsCore
{
    use UsesTenantConnection;
    protected $table = 'ubigeo_provinces';

    protected $appends = ["code"];

    public function getCodeAttribute()
    {
        return $this->attributes['id'];
    }

    static function idByDescription($description)
    {
        $province = Province::where('name', $description)->first();
        if ($province) {
            return $province->id;
        }
        return '1501';
    }
}
