<?php
/**
 * Created by PhpStorm.
 * User: Lenovo-PC
 * Date: 21/06/2020
 * Time: 12:14 PM
 */

namespace App\Models\Tenant\Ubigeo\UbigeoDetail;


use App\Models\Contract\BaseRepositoryInterface;

class UbigeoDetailRepository implements BaseRepositoryInterface
{
    protected $obj;

    public function __construct()
    {
        $this->obj = new UbigeoDetail();
    }

    public function model()
    {
        return $this->obj;
    }

    public function all()
    {
        return $this->obj->all();
    }

    public function create(array $attributes)
    {

    }

    public function createUbigeoClient(array $attributes)
    {
        $item = new UbigeoDetail();
        $item->department_id = $attributes['department_id'];
        $item->province_id = $attributes['province_id'];
        $item->district_id = $attributes['district_id'];
        $item->client_id = $attributes['client_id'];
        $item->save();
        return $item;
    }

    public function createUbigeoProvider(array $attributes)
    {
        $item = new UbigeoDetail();
        $item->department_id = $attributes['department_id'];
        $item->province_id = $attributes['province_id'];
        $item->district_id = $attributes['district_id'];
        $item->provider_id = $attributes['provider_id'];
        $item->save();
        return $item;
    }

    public function findUbigeoClient($client_id)
    {
        $item = $this->obj->where('client_id',$client_id)->first();
        return $item;
    }

    public function findUbigeoProvider($provider_id)
    {
        $item = $this->obj->where('provider_id',$provider_id)->first();
        return $item;
    }

    public function updatedUbigeoClient($attributes)
    {
        $item = $this->obj->where('client_id',$attributes['client_id'])->first();

        if ($item){
            $item->department_id = $attributes['department_id'];
            $item->province_id = $attributes['province_id'];
            $item->district_id = $attributes['district_id'];
            $item->save();
        }
        else{
            $item = $this->createUbigeoClient($attributes);
        }

        return $item;
    }


    public function updatedUbigeoProvider($attributes)
    {
        $item = $this->obj->where('provider_id',$attributes['provider_id'])->first();

        if ($item){
            $item->department_id = $attributes['department_id'];
            $item->province_id = $attributes['province_id'];
            $item->district_id = $attributes['district_id'];
            $item->save();
        }
        else{
            $item = $this->createUbigeoProvider($attributes);
        }

        return $item;
    }

    public function updated($id, array $attributes)
    {
        // TODO: Implement updated() method.
    }

    public function find($id)
    {
        // TODO: Implement find() method.
    }

    public function deleted($id)
    {
        // TODO: Implement deleted() method.
    }

    public function search($text)
    {
        // TODO: Implement search() method.
    }
}